package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ActionRemoteIpDetails(
    ipAddressV4: Option[NonEmptyString] = None,
    organization: Option[zio.aws.securityhub.model.IpOrganizationDetails] =
      None,
    country: Option[zio.aws.securityhub.model.Country] = None,
    city: Option[zio.aws.securityhub.model.City] = None,
    geoLocation: Option[zio.aws.securityhub.model.GeoLocation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ActionRemoteIpDetails = {
    import ActionRemoteIpDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ActionRemoteIpDetails
      .builder()
      .optionallyWith(
        ipAddressV4.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ipAddressV4)
      .optionallyWith(organization.map(value => value.buildAwsValue()))(
        _.organization
      )
      .optionallyWith(country.map(value => value.buildAwsValue()))(_.country)
      .optionallyWith(city.map(value => value.buildAwsValue()))(_.city)
      .optionallyWith(geoLocation.map(value => value.buildAwsValue()))(
        _.geoLocation
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.ActionRemoteIpDetails.ReadOnly =
    zio.aws.securityhub.model.ActionRemoteIpDetails.wrap(buildAwsValue())
}
object ActionRemoteIpDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ActionRemoteIpDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ActionRemoteIpDetails =
      zio.aws.securityhub.model.ActionRemoteIpDetails(
        ipAddressV4.map(value => value),
        organization.map(value => value.asEditable),
        country.map(value => value.asEditable),
        city.map(value => value.asEditable),
        geoLocation.map(value => value.asEditable)
      )
    def ipAddressV4: Option[NonEmptyString]
    def organization
        : Option[zio.aws.securityhub.model.IpOrganizationDetails.ReadOnly]
    def country: Option[zio.aws.securityhub.model.Country.ReadOnly]
    def city: Option[zio.aws.securityhub.model.City.ReadOnly]
    def geoLocation: Option[zio.aws.securityhub.model.GeoLocation.ReadOnly]
    def getIpAddressV4: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ipAddressV4", ipAddressV4)
    def getOrganization: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.IpOrganizationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("organization", organization)
    def getCountry
        : ZIO[Any, AwsError, zio.aws.securityhub.model.Country.ReadOnly] =
      AwsError.unwrapOptionField("country", country)
    def getCity: ZIO[Any, AwsError, zio.aws.securityhub.model.City.ReadOnly] =
      AwsError.unwrapOptionField("city", city)
    def getGeoLocation
        : ZIO[Any, AwsError, zio.aws.securityhub.model.GeoLocation.ReadOnly] =
      AwsError.unwrapOptionField("geoLocation", geoLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ActionRemoteIpDetails
  ) extends zio.aws.securityhub.model.ActionRemoteIpDetails.ReadOnly {
    override val ipAddressV4: Option[NonEmptyString] = scala
      .Option(impl.ipAddressV4())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val organization
        : Option[zio.aws.securityhub.model.IpOrganizationDetails.ReadOnly] =
      scala
        .Option(impl.organization())
        .map(value =>
          zio.aws.securityhub.model.IpOrganizationDetails.wrap(value)
        )
    override val country: Option[zio.aws.securityhub.model.Country.ReadOnly] =
      scala
        .Option(impl.country())
        .map(value => zio.aws.securityhub.model.Country.wrap(value))
    override val city: Option[zio.aws.securityhub.model.City.ReadOnly] = scala
      .Option(impl.city())
      .map(value => zio.aws.securityhub.model.City.wrap(value))
    override val geoLocation
        : Option[zio.aws.securityhub.model.GeoLocation.ReadOnly] = scala
      .Option(impl.geoLocation())
      .map(value => zio.aws.securityhub.model.GeoLocation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ActionRemoteIpDetails
  ): zio.aws.securityhub.model.ActionRemoteIpDetails.ReadOnly = new Wrapper(
    impl
  )
}
