package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class WorkflowUpdate(
    status: Option[zio.aws.securityhub.model.WorkflowStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.WorkflowUpdate = {
    import WorkflowUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.WorkflowUpdate
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.WorkflowUpdate.ReadOnly =
    zio.aws.securityhub.model.WorkflowUpdate.wrap(buildAwsValue())
}
object WorkflowUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.WorkflowUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.WorkflowUpdate =
      zio.aws.securityhub.model.WorkflowUpdate(status.map(value => value))
    def status: Option[zio.aws.securityhub.model.WorkflowStatus]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.securityhub.model.WorkflowStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.WorkflowUpdate
  ) extends zio.aws.securityhub.model.WorkflowUpdate.ReadOnly {
    override val status: Option[zio.aws.securityhub.model.WorkflowStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.securityhub.model.WorkflowStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.WorkflowUpdate
  ): zio.aws.securityhub.model.WorkflowUpdate.ReadOnly = new Wrapper(impl)
}
