package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Standard(
    standardsArn: Option[NonEmptyString] = None,
    name: Option[NonEmptyString] = None,
    description: Option[NonEmptyString] = None,
    enabledByDefault: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Standard = {
    import Standard.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Standard
      .builder()
      .optionallyWith(
        standardsArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.standardsArn)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(enabledByDefault.map(value => value: java.lang.Boolean))(
        _.enabledByDefault
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Standard.ReadOnly =
    zio.aws.securityhub.model.Standard.wrap(buildAwsValue())
}
object Standard {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Standard
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Standard =
      zio.aws.securityhub.model.Standard(
        standardsArn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        enabledByDefault.map(value => value)
      )
    def standardsArn: Option[NonEmptyString]
    def name: Option[NonEmptyString]
    def description: Option[NonEmptyString]
    def enabledByDefault: Option[Boolean]
    def getStandardsArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("standardsArn", standardsArn)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getEnabledByDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabledByDefault", enabledByDefault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Standard
  ) extends zio.aws.securityhub.model.Standard.ReadOnly {
    override val standardsArn: Option[NonEmptyString] = scala
      .Option(impl.standardsArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val enabledByDefault: Option[Boolean] =
      scala.Option(impl.enabledByDefault()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Standard
  ): zio.aws.securityhub.model.Standard.ReadOnly = new Wrapper(impl)
}
