package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait SeverityLabel {
  def unwrap: software.amazon.awssdk.services.securityhub.model.SeverityLabel
}
object SeverityLabel {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.SeverityLabel
  ): zio.aws.securityhub.model.SeverityLabel = value match {
    case software.amazon.awssdk.services.securityhub.model.SeverityLabel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.SeverityLabel.INFORMATIONAL =>
      val r = INFORMATIONAL
      r
    case software.amazon.awssdk.services.securityhub.model.SeverityLabel.LOW =>
      val r = LOW
      r
    case software.amazon.awssdk.services.securityhub.model.SeverityLabel.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.securityhub.model.SeverityLabel.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.securityhub.model.SeverityLabel.CRITICAL =>
      val r = CRITICAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.SeverityLabel {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.SeverityLabel =
      software.amazon.awssdk.services.securityhub.model.SeverityLabel.UNKNOWN_TO_SDK_VERSION
  }
  case object INFORMATIONAL extends zio.aws.securityhub.model.SeverityLabel {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.SeverityLabel =
      software.amazon.awssdk.services.securityhub.model.SeverityLabel.INFORMATIONAL
  }
  case object LOW extends zio.aws.securityhub.model.SeverityLabel {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.SeverityLabel =
      software.amazon.awssdk.services.securityhub.model.SeverityLabel.LOW
  }
  case object MEDIUM extends zio.aws.securityhub.model.SeverityLabel {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.SeverityLabel =
      software.amazon.awssdk.services.securityhub.model.SeverityLabel.MEDIUM
  }
  case object HIGH extends zio.aws.securityhub.model.SeverityLabel {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.SeverityLabel =
      software.amazon.awssdk.services.securityhub.model.SeverityLabel.HIGH
  }
  case object CRITICAL extends zio.aws.securityhub.model.SeverityLabel {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.SeverityLabel =
      software.amazon.awssdk.services.securityhub.model.SeverityLabel.CRITICAL
  }
}
