package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, AccountId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Result(
    accountId: Option[AccountId] = None,
    processingResult: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Result = {
    import Result.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Result
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        processingResult.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.processingResult)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Result.ReadOnly =
    zio.aws.securityhub.model.Result.wrap(buildAwsValue())
}
object Result {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Result
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Result =
      zio.aws.securityhub.model.Result(
        accountId.map(value => value),
        processingResult.map(value => value)
      )
    def accountId: Option[AccountId]
    def processingResult: Option[NonEmptyString]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getProcessingResult: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("processingResult", processingResult)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Result
  ) extends zio.aws.securityhub.model.Result.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.securityhub.model.primitives.AccountId(value))
    override val processingResult: Option[NonEmptyString] = scala
      .Option(impl.processingResult())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Result
  ): zio.aws.securityhub.model.Result.ReadOnly = new Wrapper(impl)
}
