package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResourceDetails(
    awsAutoScalingAutoScalingGroup: Option[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupDetails
    ] = None,
    awsCodeBuildProject: Option[
      zio.aws.securityhub.model.AwsCodeBuildProjectDetails
    ] = None,
    awsCloudFrontDistribution: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionDetails
    ] = None,
    awsEc2Instance: Option[zio.aws.securityhub.model.AwsEc2InstanceDetails] =
      None,
    awsEc2NetworkInterface: Option[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceDetails
    ] = None,
    awsEc2SecurityGroup: Option[
      zio.aws.securityhub.model.AwsEc2SecurityGroupDetails
    ] = None,
    awsEc2Volume: Option[zio.aws.securityhub.model.AwsEc2VolumeDetails] = None,
    awsEc2Vpc: Option[zio.aws.securityhub.model.AwsEc2VpcDetails] = None,
    awsEc2Eip: Option[zio.aws.securityhub.model.AwsEc2EipDetails] = None,
    awsEc2Subnet: Option[zio.aws.securityhub.model.AwsEc2SubnetDetails] = None,
    awsEc2NetworkAcl: Option[
      zio.aws.securityhub.model.AwsEc2NetworkAclDetails
    ] = None,
    awsElbv2LoadBalancer: Option[
      zio.aws.securityhub.model.AwsElbv2LoadBalancerDetails
    ] = None,
    awsElasticBeanstalkEnvironment: Option[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentDetails
    ] = None,
    awsElasticsearchDomain: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainDetails
    ] = None,
    awsS3Bucket: Option[zio.aws.securityhub.model.AwsS3BucketDetails] = None,
    awsS3AccountPublicAccessBlock: Option[
      zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails
    ] = None,
    awsS3Object: Option[zio.aws.securityhub.model.AwsS3ObjectDetails] = None,
    awsSecretsManagerSecret: Option[
      zio.aws.securityhub.model.AwsSecretsManagerSecretDetails
    ] = None,
    awsIamAccessKey: Option[zio.aws.securityhub.model.AwsIamAccessKeyDetails] =
      None,
    awsIamUser: Option[zio.aws.securityhub.model.AwsIamUserDetails] = None,
    awsIamPolicy: Option[zio.aws.securityhub.model.AwsIamPolicyDetails] = None,
    awsApiGatewayV2Stage: Option[
      zio.aws.securityhub.model.AwsApiGatewayV2StageDetails
    ] = None,
    awsApiGatewayV2Api: Option[
      zio.aws.securityhub.model.AwsApiGatewayV2ApiDetails
    ] = None,
    awsDynamoDbTable: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableDetails
    ] = None,
    awsApiGatewayStage: Option[
      zio.aws.securityhub.model.AwsApiGatewayStageDetails
    ] = None,
    awsApiGatewayRestApi: Option[
      zio.aws.securityhub.model.AwsApiGatewayRestApiDetails
    ] = None,
    awsCloudTrailTrail: Option[
      zio.aws.securityhub.model.AwsCloudTrailTrailDetails
    ] = None,
    awsSsmPatchCompliance: Option[
      zio.aws.securityhub.model.AwsSsmPatchComplianceDetails
    ] = None,
    awsCertificateManagerCertificate: Option[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDetails
    ] = None,
    awsRedshiftCluster: Option[
      zio.aws.securityhub.model.AwsRedshiftClusterDetails
    ] = None,
    awsElbLoadBalancer: Option[
      zio.aws.securityhub.model.AwsElbLoadBalancerDetails
    ] = None,
    awsIamGroup: Option[zio.aws.securityhub.model.AwsIamGroupDetails] = None,
    awsIamRole: Option[zio.aws.securityhub.model.AwsIamRoleDetails] = None,
    awsKmsKey: Option[zio.aws.securityhub.model.AwsKmsKeyDetails] = None,
    awsLambdaFunction: Option[
      zio.aws.securityhub.model.AwsLambdaFunctionDetails
    ] = None,
    awsLambdaLayerVersion: Option[
      zio.aws.securityhub.model.AwsLambdaLayerVersionDetails
    ] = None,
    awsRdsDbInstance: Option[
      zio.aws.securityhub.model.AwsRdsDbInstanceDetails
    ] = None,
    awsSnsTopic: Option[zio.aws.securityhub.model.AwsSnsTopicDetails] = None,
    awsSqsQueue: Option[zio.aws.securityhub.model.AwsSqsQueueDetails] = None,
    awsWafWebAcl: Option[zio.aws.securityhub.model.AwsWafWebAclDetails] = None,
    awsRdsDbSnapshot: Option[
      zio.aws.securityhub.model.AwsRdsDbSnapshotDetails
    ] = None,
    awsRdsDbClusterSnapshot: Option[
      zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDetails
    ] = None,
    awsRdsDbCluster: Option[zio.aws.securityhub.model.AwsRdsDbClusterDetails] =
      None,
    awsEcsCluster: Option[zio.aws.securityhub.model.AwsEcsClusterDetails] =
      None,
    awsEcsTaskDefinition: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionDetails
    ] = None,
    container: Option[zio.aws.securityhub.model.ContainerDetails] = None,
    other: Option[Map[NonEmptyString, NonEmptyString]] = None,
    awsRdsEventSubscription: Option[
      zio.aws.securityhub.model.AwsRdsEventSubscriptionDetails
    ] = None,
    awsEcsService: Option[zio.aws.securityhub.model.AwsEcsServiceDetails] =
      None,
    awsAutoScalingLaunchConfiguration: Option[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationDetails
    ] = None,
    awsEc2VpnConnection: Option[
      zio.aws.securityhub.model.AwsEc2VpnConnectionDetails
    ] = None,
    awsEcrContainerImage: Option[
      zio.aws.securityhub.model.AwsEcrContainerImageDetails
    ] = None,
    awsOpenSearchServiceDomain: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainDetails
    ] = None,
    awsEc2VpcEndpointService: Option[
      zio.aws.securityhub.model.AwsEc2VpcEndpointServiceDetails
    ] = None,
    awsXrayEncryptionConfig: Option[
      zio.aws.securityhub.model.AwsXrayEncryptionConfigDetails
    ] = None,
    awsWafRateBasedRule: Option[
      zio.aws.securityhub.model.AwsWafRateBasedRuleDetails
    ] = None,
    awsWafRegionalRateBasedRule: Option[
      zio.aws.securityhub.model.AwsWafRegionalRateBasedRuleDetails
    ] = None,
    awsEcrRepository: Option[
      zio.aws.securityhub.model.AwsEcrRepositoryDetails
    ] = None,
    awsEksCluster: Option[zio.aws.securityhub.model.AwsEksClusterDetails] =
      None,
    awsNetworkFirewallFirewallPolicy: Option[
      zio.aws.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails
    ] = None,
    awsNetworkFirewallFirewall: Option[
      zio.aws.securityhub.model.AwsNetworkFirewallFirewallDetails
    ] = None,
    awsNetworkFirewallRuleGroup: Option[
      zio.aws.securityhub.model.AwsNetworkFirewallRuleGroupDetails
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ResourceDetails = {
    import ResourceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ResourceDetails
      .builder()
      .optionallyWith(
        awsAutoScalingAutoScalingGroup.map(value => value.buildAwsValue())
      )(_.awsAutoScalingAutoScalingGroup)
      .optionallyWith(awsCodeBuildProject.map(value => value.buildAwsValue()))(
        _.awsCodeBuildProject
      )
      .optionallyWith(
        awsCloudFrontDistribution.map(value => value.buildAwsValue())
      )(_.awsCloudFrontDistribution)
      .optionallyWith(awsEc2Instance.map(value => value.buildAwsValue()))(
        _.awsEc2Instance
      )
      .optionallyWith(
        awsEc2NetworkInterface.map(value => value.buildAwsValue())
      )(_.awsEc2NetworkInterface)
      .optionallyWith(awsEc2SecurityGroup.map(value => value.buildAwsValue()))(
        _.awsEc2SecurityGroup
      )
      .optionallyWith(awsEc2Volume.map(value => value.buildAwsValue()))(
        _.awsEc2Volume
      )
      .optionallyWith(awsEc2Vpc.map(value => value.buildAwsValue()))(
        _.awsEc2Vpc
      )
      .optionallyWith(awsEc2Eip.map(value => value.buildAwsValue()))(
        _.awsEc2Eip
      )
      .optionallyWith(awsEc2Subnet.map(value => value.buildAwsValue()))(
        _.awsEc2Subnet
      )
      .optionallyWith(awsEc2NetworkAcl.map(value => value.buildAwsValue()))(
        _.awsEc2NetworkAcl
      )
      .optionallyWith(awsElbv2LoadBalancer.map(value => value.buildAwsValue()))(
        _.awsElbv2LoadBalancer
      )
      .optionallyWith(
        awsElasticBeanstalkEnvironment.map(value => value.buildAwsValue())
      )(_.awsElasticBeanstalkEnvironment)
      .optionallyWith(
        awsElasticsearchDomain.map(value => value.buildAwsValue())
      )(_.awsElasticsearchDomain)
      .optionallyWith(awsS3Bucket.map(value => value.buildAwsValue()))(
        _.awsS3Bucket
      )
      .optionallyWith(
        awsS3AccountPublicAccessBlock.map(value => value.buildAwsValue())
      )(_.awsS3AccountPublicAccessBlock)
      .optionallyWith(awsS3Object.map(value => value.buildAwsValue()))(
        _.awsS3Object
      )
      .optionallyWith(
        awsSecretsManagerSecret.map(value => value.buildAwsValue())
      )(_.awsSecretsManagerSecret)
      .optionallyWith(awsIamAccessKey.map(value => value.buildAwsValue()))(
        _.awsIamAccessKey
      )
      .optionallyWith(awsIamUser.map(value => value.buildAwsValue()))(
        _.awsIamUser
      )
      .optionallyWith(awsIamPolicy.map(value => value.buildAwsValue()))(
        _.awsIamPolicy
      )
      .optionallyWith(awsApiGatewayV2Stage.map(value => value.buildAwsValue()))(
        _.awsApiGatewayV2Stage
      )
      .optionallyWith(awsApiGatewayV2Api.map(value => value.buildAwsValue()))(
        _.awsApiGatewayV2Api
      )
      .optionallyWith(awsDynamoDbTable.map(value => value.buildAwsValue()))(
        _.awsDynamoDbTable
      )
      .optionallyWith(awsApiGatewayStage.map(value => value.buildAwsValue()))(
        _.awsApiGatewayStage
      )
      .optionallyWith(awsApiGatewayRestApi.map(value => value.buildAwsValue()))(
        _.awsApiGatewayRestApi
      )
      .optionallyWith(awsCloudTrailTrail.map(value => value.buildAwsValue()))(
        _.awsCloudTrailTrail
      )
      .optionallyWith(
        awsSsmPatchCompliance.map(value => value.buildAwsValue())
      )(_.awsSsmPatchCompliance)
      .optionallyWith(
        awsCertificateManagerCertificate.map(value => value.buildAwsValue())
      )(_.awsCertificateManagerCertificate)
      .optionallyWith(awsRedshiftCluster.map(value => value.buildAwsValue()))(
        _.awsRedshiftCluster
      )
      .optionallyWith(awsElbLoadBalancer.map(value => value.buildAwsValue()))(
        _.awsElbLoadBalancer
      )
      .optionallyWith(awsIamGroup.map(value => value.buildAwsValue()))(
        _.awsIamGroup
      )
      .optionallyWith(awsIamRole.map(value => value.buildAwsValue()))(
        _.awsIamRole
      )
      .optionallyWith(awsKmsKey.map(value => value.buildAwsValue()))(
        _.awsKmsKey
      )
      .optionallyWith(awsLambdaFunction.map(value => value.buildAwsValue()))(
        _.awsLambdaFunction
      )
      .optionallyWith(
        awsLambdaLayerVersion.map(value => value.buildAwsValue())
      )(_.awsLambdaLayerVersion)
      .optionallyWith(awsRdsDbInstance.map(value => value.buildAwsValue()))(
        _.awsRdsDbInstance
      )
      .optionallyWith(awsSnsTopic.map(value => value.buildAwsValue()))(
        _.awsSnsTopic
      )
      .optionallyWith(awsSqsQueue.map(value => value.buildAwsValue()))(
        _.awsSqsQueue
      )
      .optionallyWith(awsWafWebAcl.map(value => value.buildAwsValue()))(
        _.awsWafWebAcl
      )
      .optionallyWith(awsRdsDbSnapshot.map(value => value.buildAwsValue()))(
        _.awsRdsDbSnapshot
      )
      .optionallyWith(
        awsRdsDbClusterSnapshot.map(value => value.buildAwsValue())
      )(_.awsRdsDbClusterSnapshot)
      .optionallyWith(awsRdsDbCluster.map(value => value.buildAwsValue()))(
        _.awsRdsDbCluster
      )
      .optionallyWith(awsEcsCluster.map(value => value.buildAwsValue()))(
        _.awsEcsCluster
      )
      .optionallyWith(awsEcsTaskDefinition.map(value => value.buildAwsValue()))(
        _.awsEcsTaskDefinition
      )
      .optionallyWith(container.map(value => value.buildAwsValue()))(
        _.container
      )
      .optionallyWith(
        other.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.other)
      .optionallyWith(
        awsRdsEventSubscription.map(value => value.buildAwsValue())
      )(_.awsRdsEventSubscription)
      .optionallyWith(awsEcsService.map(value => value.buildAwsValue()))(
        _.awsEcsService
      )
      .optionallyWith(
        awsAutoScalingLaunchConfiguration.map(value => value.buildAwsValue())
      )(_.awsAutoScalingLaunchConfiguration)
      .optionallyWith(awsEc2VpnConnection.map(value => value.buildAwsValue()))(
        _.awsEc2VpnConnection
      )
      .optionallyWith(awsEcrContainerImage.map(value => value.buildAwsValue()))(
        _.awsEcrContainerImage
      )
      .optionallyWith(
        awsOpenSearchServiceDomain.map(value => value.buildAwsValue())
      )(_.awsOpenSearchServiceDomain)
      .optionallyWith(
        awsEc2VpcEndpointService.map(value => value.buildAwsValue())
      )(_.awsEc2VpcEndpointService)
      .optionallyWith(
        awsXrayEncryptionConfig.map(value => value.buildAwsValue())
      )(_.awsXrayEncryptionConfig)
      .optionallyWith(awsWafRateBasedRule.map(value => value.buildAwsValue()))(
        _.awsWafRateBasedRule
      )
      .optionallyWith(
        awsWafRegionalRateBasedRule.map(value => value.buildAwsValue())
      )(_.awsWafRegionalRateBasedRule)
      .optionallyWith(awsEcrRepository.map(value => value.buildAwsValue()))(
        _.awsEcrRepository
      )
      .optionallyWith(awsEksCluster.map(value => value.buildAwsValue()))(
        _.awsEksCluster
      )
      .optionallyWith(
        awsNetworkFirewallFirewallPolicy.map(value => value.buildAwsValue())
      )(_.awsNetworkFirewallFirewallPolicy)
      .optionallyWith(
        awsNetworkFirewallFirewall.map(value => value.buildAwsValue())
      )(_.awsNetworkFirewallFirewall)
      .optionallyWith(
        awsNetworkFirewallRuleGroup.map(value => value.buildAwsValue())
      )(_.awsNetworkFirewallRuleGroup)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.ResourceDetails.ReadOnly =
    zio.aws.securityhub.model.ResourceDetails.wrap(buildAwsValue())
}
object ResourceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ResourceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ResourceDetails =
      zio.aws.securityhub.model.ResourceDetails(
        awsAutoScalingAutoScalingGroup.map(value => value.asEditable),
        awsCodeBuildProject.map(value => value.asEditable),
        awsCloudFrontDistribution.map(value => value.asEditable),
        awsEc2Instance.map(value => value.asEditable),
        awsEc2NetworkInterface.map(value => value.asEditable),
        awsEc2SecurityGroup.map(value => value.asEditable),
        awsEc2Volume.map(value => value.asEditable),
        awsEc2Vpc.map(value => value.asEditable),
        awsEc2Eip.map(value => value.asEditable),
        awsEc2Subnet.map(value => value.asEditable),
        awsEc2NetworkAcl.map(value => value.asEditable),
        awsElbv2LoadBalancer.map(value => value.asEditable),
        awsElasticBeanstalkEnvironment.map(value => value.asEditable),
        awsElasticsearchDomain.map(value => value.asEditable),
        awsS3Bucket.map(value => value.asEditable),
        awsS3AccountPublicAccessBlock.map(value => value.asEditable),
        awsS3Object.map(value => value.asEditable),
        awsSecretsManagerSecret.map(value => value.asEditable),
        awsIamAccessKey.map(value => value.asEditable),
        awsIamUser.map(value => value.asEditable),
        awsIamPolicy.map(value => value.asEditable),
        awsApiGatewayV2Stage.map(value => value.asEditable),
        awsApiGatewayV2Api.map(value => value.asEditable),
        awsDynamoDbTable.map(value => value.asEditable),
        awsApiGatewayStage.map(value => value.asEditable),
        awsApiGatewayRestApi.map(value => value.asEditable),
        awsCloudTrailTrail.map(value => value.asEditable),
        awsSsmPatchCompliance.map(value => value.asEditable),
        awsCertificateManagerCertificate.map(value => value.asEditable),
        awsRedshiftCluster.map(value => value.asEditable),
        awsElbLoadBalancer.map(value => value.asEditable),
        awsIamGroup.map(value => value.asEditable),
        awsIamRole.map(value => value.asEditable),
        awsKmsKey.map(value => value.asEditable),
        awsLambdaFunction.map(value => value.asEditable),
        awsLambdaLayerVersion.map(value => value.asEditable),
        awsRdsDbInstance.map(value => value.asEditable),
        awsSnsTopic.map(value => value.asEditable),
        awsSqsQueue.map(value => value.asEditable),
        awsWafWebAcl.map(value => value.asEditable),
        awsRdsDbSnapshot.map(value => value.asEditable),
        awsRdsDbClusterSnapshot.map(value => value.asEditable),
        awsRdsDbCluster.map(value => value.asEditable),
        awsEcsCluster.map(value => value.asEditable),
        awsEcsTaskDefinition.map(value => value.asEditable),
        container.map(value => value.asEditable),
        other.map(value => value),
        awsRdsEventSubscription.map(value => value.asEditable),
        awsEcsService.map(value => value.asEditable),
        awsAutoScalingLaunchConfiguration.map(value => value.asEditable),
        awsEc2VpnConnection.map(value => value.asEditable),
        awsEcrContainerImage.map(value => value.asEditable),
        awsOpenSearchServiceDomain.map(value => value.asEditable),
        awsEc2VpcEndpointService.map(value => value.asEditable),
        awsXrayEncryptionConfig.map(value => value.asEditable),
        awsWafRateBasedRule.map(value => value.asEditable),
        awsWafRegionalRateBasedRule.map(value => value.asEditable),
        awsEcrRepository.map(value => value.asEditable),
        awsEksCluster.map(value => value.asEditable),
        awsNetworkFirewallFirewallPolicy.map(value => value.asEditable),
        awsNetworkFirewallFirewall.map(value => value.asEditable),
        awsNetworkFirewallRuleGroup.map(value => value.asEditable)
      )
    def awsAutoScalingAutoScalingGroup: Option[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupDetails.ReadOnly
    ]
    def awsCodeBuildProject
        : Option[zio.aws.securityhub.model.AwsCodeBuildProjectDetails.ReadOnly]
    def awsCloudFrontDistribution: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionDetails.ReadOnly
    ]
    def awsEc2Instance
        : Option[zio.aws.securityhub.model.AwsEc2InstanceDetails.ReadOnly]
    def awsEc2NetworkInterface: Option[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceDetails.ReadOnly
    ]
    def awsEc2SecurityGroup
        : Option[zio.aws.securityhub.model.AwsEc2SecurityGroupDetails.ReadOnly]
    def awsEc2Volume
        : Option[zio.aws.securityhub.model.AwsEc2VolumeDetails.ReadOnly]
    def awsEc2Vpc: Option[zio.aws.securityhub.model.AwsEc2VpcDetails.ReadOnly]
    def awsEc2Eip: Option[zio.aws.securityhub.model.AwsEc2EipDetails.ReadOnly]
    def awsEc2Subnet
        : Option[zio.aws.securityhub.model.AwsEc2SubnetDetails.ReadOnly]
    def awsEc2NetworkAcl
        : Option[zio.aws.securityhub.model.AwsEc2NetworkAclDetails.ReadOnly]
    def awsElbv2LoadBalancer
        : Option[zio.aws.securityhub.model.AwsElbv2LoadBalancerDetails.ReadOnly]
    def awsElasticBeanstalkEnvironment: Option[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentDetails.ReadOnly
    ]
    def awsElasticsearchDomain: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainDetails.ReadOnly
    ]
    def awsS3Bucket
        : Option[zio.aws.securityhub.model.AwsS3BucketDetails.ReadOnly]
    def awsS3AccountPublicAccessBlock: Option[
      zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails.ReadOnly
    ]
    def awsS3Object
        : Option[zio.aws.securityhub.model.AwsS3ObjectDetails.ReadOnly]
    def awsSecretsManagerSecret: Option[
      zio.aws.securityhub.model.AwsSecretsManagerSecretDetails.ReadOnly
    ]
    def awsIamAccessKey
        : Option[zio.aws.securityhub.model.AwsIamAccessKeyDetails.ReadOnly]
    def awsIamUser: Option[zio.aws.securityhub.model.AwsIamUserDetails.ReadOnly]
    def awsIamPolicy
        : Option[zio.aws.securityhub.model.AwsIamPolicyDetails.ReadOnly]
    def awsApiGatewayV2Stage
        : Option[zio.aws.securityhub.model.AwsApiGatewayV2StageDetails.ReadOnly]
    def awsApiGatewayV2Api
        : Option[zio.aws.securityhub.model.AwsApiGatewayV2ApiDetails.ReadOnly]
    def awsDynamoDbTable
        : Option[zio.aws.securityhub.model.AwsDynamoDbTableDetails.ReadOnly]
    def awsApiGatewayStage
        : Option[zio.aws.securityhub.model.AwsApiGatewayStageDetails.ReadOnly]
    def awsApiGatewayRestApi
        : Option[zio.aws.securityhub.model.AwsApiGatewayRestApiDetails.ReadOnly]
    def awsCloudTrailTrail
        : Option[zio.aws.securityhub.model.AwsCloudTrailTrailDetails.ReadOnly]
    def awsSsmPatchCompliance: Option[
      zio.aws.securityhub.model.AwsSsmPatchComplianceDetails.ReadOnly
    ]
    def awsCertificateManagerCertificate: Option[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDetails.ReadOnly
    ]
    def awsRedshiftCluster
        : Option[zio.aws.securityhub.model.AwsRedshiftClusterDetails.ReadOnly]
    def awsElbLoadBalancer
        : Option[zio.aws.securityhub.model.AwsElbLoadBalancerDetails.ReadOnly]
    def awsIamGroup
        : Option[zio.aws.securityhub.model.AwsIamGroupDetails.ReadOnly]
    def awsIamRole: Option[zio.aws.securityhub.model.AwsIamRoleDetails.ReadOnly]
    def awsKmsKey: Option[zio.aws.securityhub.model.AwsKmsKeyDetails.ReadOnly]
    def awsLambdaFunction
        : Option[zio.aws.securityhub.model.AwsLambdaFunctionDetails.ReadOnly]
    def awsLambdaLayerVersion: Option[
      zio.aws.securityhub.model.AwsLambdaLayerVersionDetails.ReadOnly
    ]
    def awsRdsDbInstance
        : Option[zio.aws.securityhub.model.AwsRdsDbInstanceDetails.ReadOnly]
    def awsSnsTopic
        : Option[zio.aws.securityhub.model.AwsSnsTopicDetails.ReadOnly]
    def awsSqsQueue
        : Option[zio.aws.securityhub.model.AwsSqsQueueDetails.ReadOnly]
    def awsWafWebAcl
        : Option[zio.aws.securityhub.model.AwsWafWebAclDetails.ReadOnly]
    def awsRdsDbSnapshot
        : Option[zio.aws.securityhub.model.AwsRdsDbSnapshotDetails.ReadOnly]
    def awsRdsDbClusterSnapshot: Option[
      zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDetails.ReadOnly
    ]
    def awsRdsDbCluster
        : Option[zio.aws.securityhub.model.AwsRdsDbClusterDetails.ReadOnly]
    def awsEcsCluster
        : Option[zio.aws.securityhub.model.AwsEcsClusterDetails.ReadOnly]
    def awsEcsTaskDefinition
        : Option[zio.aws.securityhub.model.AwsEcsTaskDefinitionDetails.ReadOnly]
    def container: Option[zio.aws.securityhub.model.ContainerDetails.ReadOnly]
    def other: Option[Map[NonEmptyString, NonEmptyString]]
    def awsRdsEventSubscription: Option[
      zio.aws.securityhub.model.AwsRdsEventSubscriptionDetails.ReadOnly
    ]
    def awsEcsService
        : Option[zio.aws.securityhub.model.AwsEcsServiceDetails.ReadOnly]
    def awsAutoScalingLaunchConfiguration: Option[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationDetails.ReadOnly
    ]
    def awsEc2VpnConnection
        : Option[zio.aws.securityhub.model.AwsEc2VpnConnectionDetails.ReadOnly]
    def awsEcrContainerImage
        : Option[zio.aws.securityhub.model.AwsEcrContainerImageDetails.ReadOnly]
    def awsOpenSearchServiceDomain: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainDetails.ReadOnly
    ]
    def awsEc2VpcEndpointService: Option[
      zio.aws.securityhub.model.AwsEc2VpcEndpointServiceDetails.ReadOnly
    ]
    def awsXrayEncryptionConfig: Option[
      zio.aws.securityhub.model.AwsXrayEncryptionConfigDetails.ReadOnly
    ]
    def awsWafRateBasedRule
        : Option[zio.aws.securityhub.model.AwsWafRateBasedRuleDetails.ReadOnly]
    def awsWafRegionalRateBasedRule: Option[
      zio.aws.securityhub.model.AwsWafRegionalRateBasedRuleDetails.ReadOnly
    ]
    def awsEcrRepository
        : Option[zio.aws.securityhub.model.AwsEcrRepositoryDetails.ReadOnly]
    def awsEksCluster
        : Option[zio.aws.securityhub.model.AwsEksClusterDetails.ReadOnly]
    def awsNetworkFirewallFirewallPolicy: Option[
      zio.aws.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails.ReadOnly
    ]
    def awsNetworkFirewallFirewall: Option[
      zio.aws.securityhub.model.AwsNetworkFirewallFirewallDetails.ReadOnly
    ]
    def awsNetworkFirewallRuleGroup: Option[
      zio.aws.securityhub.model.AwsNetworkFirewallRuleGroupDetails.ReadOnly
    ]
    def getAwsAutoScalingAutoScalingGroup: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsAutoScalingAutoScalingGroup",
      awsAutoScalingAutoScalingGroup
    )
    def getAwsCodeBuildProject: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCodeBuildProjectDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsCodeBuildProject", awsCodeBuildProject)
    def getAwsCloudFrontDistribution: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCloudFrontDistributionDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsCloudFrontDistribution",
      awsCloudFrontDistribution
    )
    def getAwsEc2Instance: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2InstanceDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsEc2Instance", awsEc2Instance)
    def getAwsEc2NetworkInterface: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsEc2NetworkInterface",
      awsEc2NetworkInterface
    )
    def getAwsEc2SecurityGroup: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2SecurityGroupDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsEc2SecurityGroup", awsEc2SecurityGroup)
    def getAwsEc2Volume: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2VolumeDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsEc2Volume", awsEc2Volume)
    def getAwsEc2Vpc: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2VpcDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsEc2Vpc", awsEc2Vpc)
    def getAwsEc2Eip: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2EipDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsEc2Eip", awsEc2Eip)
    def getAwsEc2Subnet: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2SubnetDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsEc2Subnet", awsEc2Subnet)
    def getAwsEc2NetworkAcl: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2NetworkAclDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsEc2NetworkAcl", awsEc2NetworkAcl)
    def getAwsElbv2LoadBalancer: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElbv2LoadBalancerDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsElbv2LoadBalancer", awsElbv2LoadBalancer)
    def getAwsElasticBeanstalkEnvironment: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsElasticBeanstalkEnvironment",
      awsElasticBeanstalkEnvironment
    )
    def getAwsElasticsearchDomain: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsElasticsearchDomain",
      awsElasticsearchDomain
    )
    def getAwsS3Bucket: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsS3Bucket", awsS3Bucket)
    def getAwsS3AccountPublicAccessBlock: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsS3AccountPublicAccessBlock",
      awsS3AccountPublicAccessBlock
    )
    def getAwsS3Object: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3ObjectDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsS3Object", awsS3Object)
    def getAwsSecretsManagerSecret: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsSecretsManagerSecretDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsSecretsManagerSecret",
      awsSecretsManagerSecret
    )
    def getAwsIamAccessKey: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsIamAccessKeyDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsIamAccessKey", awsIamAccessKey)
    def getAwsIamUser: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsIamUserDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsIamUser", awsIamUser)
    def getAwsIamPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsIamPolicyDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsIamPolicy", awsIamPolicy)
    def getAwsApiGatewayV2Stage: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsApiGatewayV2StageDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsApiGatewayV2Stage", awsApiGatewayV2Stage)
    def getAwsApiGatewayV2Api: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsApiGatewayV2ApiDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsApiGatewayV2Api", awsApiGatewayV2Api)
    def getAwsDynamoDbTable: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsDynamoDbTableDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsDynamoDbTable", awsDynamoDbTable)
    def getAwsApiGatewayStage: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsApiGatewayStageDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsApiGatewayStage", awsApiGatewayStage)
    def getAwsApiGatewayRestApi: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsApiGatewayRestApiDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsApiGatewayRestApi", awsApiGatewayRestApi)
    def getAwsCloudTrailTrail: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCloudTrailTrailDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsCloudTrailTrail", awsCloudTrailTrail)
    def getAwsSsmPatchCompliance: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsSsmPatchComplianceDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("awsSsmPatchCompliance", awsSsmPatchCompliance)
    def getAwsCertificateManagerCertificate: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsCertificateManagerCertificate",
      awsCertificateManagerCertificate
    )
    def getAwsRedshiftCluster: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRedshiftClusterDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsRedshiftCluster", awsRedshiftCluster)
    def getAwsElbLoadBalancer: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElbLoadBalancerDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsElbLoadBalancer", awsElbLoadBalancer)
    def getAwsIamGroup: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsIamGroupDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsIamGroup", awsIamGroup)
    def getAwsIamRole: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsIamRoleDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsIamRole", awsIamRole)
    def getAwsKmsKey: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsKmsKeyDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsKmsKey", awsKmsKey)
    def getAwsLambdaFunction: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsLambdaFunctionDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsLambdaFunction", awsLambdaFunction)
    def getAwsLambdaLayerVersion: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsLambdaLayerVersionDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("awsLambdaLayerVersion", awsLambdaLayerVersion)
    def getAwsRdsDbInstance: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRdsDbInstanceDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsRdsDbInstance", awsRdsDbInstance)
    def getAwsSnsTopic: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsSnsTopicDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsSnsTopic", awsSnsTopic)
    def getAwsSqsQueue: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsSqsQueueDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsSqsQueue", awsSqsQueue)
    def getAwsWafWebAcl: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafWebAclDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsWafWebAcl", awsWafWebAcl)
    def getAwsRdsDbSnapshot: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRdsDbSnapshotDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsRdsDbSnapshot", awsRdsDbSnapshot)
    def getAwsRdsDbClusterSnapshot: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsRdsDbClusterSnapshot",
      awsRdsDbClusterSnapshot
    )
    def getAwsRdsDbCluster: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRdsDbClusterDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsRdsDbCluster", awsRdsDbCluster)
    def getAwsEcsCluster: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsClusterDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsEcsCluster", awsEcsCluster)
    def getAwsEcsTaskDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsEcsTaskDefinition", awsEcsTaskDefinition)
    def getContainer: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.ContainerDetails.ReadOnly
    ] = AwsError.unwrapOptionField("container", container)
    def getOther: ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("other", other)
    def getAwsRdsEventSubscription: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRdsEventSubscriptionDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsRdsEventSubscription",
      awsRdsEventSubscription
    )
    def getAwsEcsService: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsServiceDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsEcsService", awsEcsService)
    def getAwsAutoScalingLaunchConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsAutoScalingLaunchConfiguration",
      awsAutoScalingLaunchConfiguration
    )
    def getAwsEc2VpnConnection: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2VpnConnectionDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsEc2VpnConnection", awsEc2VpnConnection)
    def getAwsEcrContainerImage: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcrContainerImageDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsEcrContainerImage", awsEcrContainerImage)
    def getAwsOpenSearchServiceDomain: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsOpenSearchServiceDomain",
      awsOpenSearchServiceDomain
    )
    def getAwsEc2VpcEndpointService: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2VpcEndpointServiceDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsEc2VpcEndpointService",
      awsEc2VpcEndpointService
    )
    def getAwsXrayEncryptionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsXrayEncryptionConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsXrayEncryptionConfig",
      awsXrayEncryptionConfig
    )
    def getAwsWafRateBasedRule: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafRateBasedRuleDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsWafRateBasedRule", awsWafRateBasedRule)
    def getAwsWafRegionalRateBasedRule: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsWafRegionalRateBasedRuleDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsWafRegionalRateBasedRule",
      awsWafRegionalRateBasedRule
    )
    def getAwsEcrRepository: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcrRepositoryDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsEcrRepository", awsEcrRepository)
    def getAwsEksCluster: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEksClusterDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsEksCluster", awsEksCluster)
    def getAwsNetworkFirewallFirewallPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsNetworkFirewallFirewallPolicy",
      awsNetworkFirewallFirewallPolicy
    )
    def getAwsNetworkFirewallFirewall: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsNetworkFirewallFirewallDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsNetworkFirewallFirewall",
      awsNetworkFirewallFirewall
    )
    def getAwsNetworkFirewallRuleGroup: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsNetworkFirewallRuleGroupDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsNetworkFirewallRuleGroup",
      awsNetworkFirewallRuleGroup
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ResourceDetails
  ) extends zio.aws.securityhub.model.ResourceDetails.ReadOnly {
    override val awsAutoScalingAutoScalingGroup: Option[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupDetails.ReadOnly
    ] = scala
      .Option(impl.awsAutoScalingAutoScalingGroup())
      .map(value =>
        zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupDetails
          .wrap(value)
      )
    override val awsCodeBuildProject: Option[
      zio.aws.securityhub.model.AwsCodeBuildProjectDetails.ReadOnly
    ] = scala
      .Option(impl.awsCodeBuildProject())
      .map(value =>
        zio.aws.securityhub.model.AwsCodeBuildProjectDetails.wrap(value)
      )
    override val awsCloudFrontDistribution: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionDetails.ReadOnly
    ] = scala
      .Option(impl.awsCloudFrontDistribution())
      .map(value =>
        zio.aws.securityhub.model.AwsCloudFrontDistributionDetails.wrap(value)
      )
    override val awsEc2Instance
        : Option[zio.aws.securityhub.model.AwsEc2InstanceDetails.ReadOnly] =
      scala
        .Option(impl.awsEc2Instance())
        .map(value =>
          zio.aws.securityhub.model.AwsEc2InstanceDetails.wrap(value)
        )
    override val awsEc2NetworkInterface: Option[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceDetails.ReadOnly
    ] = scala
      .Option(impl.awsEc2NetworkInterface())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2NetworkInterfaceDetails.wrap(value)
      )
    override val awsEc2SecurityGroup: Option[
      zio.aws.securityhub.model.AwsEc2SecurityGroupDetails.ReadOnly
    ] = scala
      .Option(impl.awsEc2SecurityGroup())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2SecurityGroupDetails.wrap(value)
      )
    override val awsEc2Volume
        : Option[zio.aws.securityhub.model.AwsEc2VolumeDetails.ReadOnly] = scala
      .Option(impl.awsEc2Volume())
      .map(value => zio.aws.securityhub.model.AwsEc2VolumeDetails.wrap(value))
    override val awsEc2Vpc
        : Option[zio.aws.securityhub.model.AwsEc2VpcDetails.ReadOnly] = scala
      .Option(impl.awsEc2Vpc())
      .map(value => zio.aws.securityhub.model.AwsEc2VpcDetails.wrap(value))
    override val awsEc2Eip
        : Option[zio.aws.securityhub.model.AwsEc2EipDetails.ReadOnly] = scala
      .Option(impl.awsEc2Eip())
      .map(value => zio.aws.securityhub.model.AwsEc2EipDetails.wrap(value))
    override val awsEc2Subnet
        : Option[zio.aws.securityhub.model.AwsEc2SubnetDetails.ReadOnly] = scala
      .Option(impl.awsEc2Subnet())
      .map(value => zio.aws.securityhub.model.AwsEc2SubnetDetails.wrap(value))
    override val awsEc2NetworkAcl
        : Option[zio.aws.securityhub.model.AwsEc2NetworkAclDetails.ReadOnly] =
      scala
        .Option(impl.awsEc2NetworkAcl())
        .map(value =>
          zio.aws.securityhub.model.AwsEc2NetworkAclDetails.wrap(value)
        )
    override val awsElbv2LoadBalancer: Option[
      zio.aws.securityhub.model.AwsElbv2LoadBalancerDetails.ReadOnly
    ] = scala
      .Option(impl.awsElbv2LoadBalancer())
      .map(value =>
        zio.aws.securityhub.model.AwsElbv2LoadBalancerDetails.wrap(value)
      )
    override val awsElasticBeanstalkEnvironment: Option[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentDetails.ReadOnly
    ] = scala
      .Option(impl.awsElasticBeanstalkEnvironment())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentDetails
          .wrap(value)
      )
    override val awsElasticsearchDomain: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainDetails.ReadOnly
    ] = scala
      .Option(impl.awsElasticsearchDomain())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainDetails.wrap(value)
      )
    override val awsS3Bucket
        : Option[zio.aws.securityhub.model.AwsS3BucketDetails.ReadOnly] = scala
      .Option(impl.awsS3Bucket())
      .map(value => zio.aws.securityhub.model.AwsS3BucketDetails.wrap(value))
    override val awsS3AccountPublicAccessBlock: Option[
      zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails.ReadOnly
    ] = scala
      .Option(impl.awsS3AccountPublicAccessBlock())
      .map(value =>
        zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails
          .wrap(value)
      )
    override val awsS3Object
        : Option[zio.aws.securityhub.model.AwsS3ObjectDetails.ReadOnly] = scala
      .Option(impl.awsS3Object())
      .map(value => zio.aws.securityhub.model.AwsS3ObjectDetails.wrap(value))
    override val awsSecretsManagerSecret: Option[
      zio.aws.securityhub.model.AwsSecretsManagerSecretDetails.ReadOnly
    ] = scala
      .Option(impl.awsSecretsManagerSecret())
      .map(value =>
        zio.aws.securityhub.model.AwsSecretsManagerSecretDetails.wrap(value)
      )
    override val awsIamAccessKey
        : Option[zio.aws.securityhub.model.AwsIamAccessKeyDetails.ReadOnly] =
      scala
        .Option(impl.awsIamAccessKey())
        .map(value =>
          zio.aws.securityhub.model.AwsIamAccessKeyDetails.wrap(value)
        )
    override val awsIamUser
        : Option[zio.aws.securityhub.model.AwsIamUserDetails.ReadOnly] = scala
      .Option(impl.awsIamUser())
      .map(value => zio.aws.securityhub.model.AwsIamUserDetails.wrap(value))
    override val awsIamPolicy
        : Option[zio.aws.securityhub.model.AwsIamPolicyDetails.ReadOnly] = scala
      .Option(impl.awsIamPolicy())
      .map(value => zio.aws.securityhub.model.AwsIamPolicyDetails.wrap(value))
    override val awsApiGatewayV2Stage: Option[
      zio.aws.securityhub.model.AwsApiGatewayV2StageDetails.ReadOnly
    ] = scala
      .Option(impl.awsApiGatewayV2Stage())
      .map(value =>
        zio.aws.securityhub.model.AwsApiGatewayV2StageDetails.wrap(value)
      )
    override val awsApiGatewayV2Api
        : Option[zio.aws.securityhub.model.AwsApiGatewayV2ApiDetails.ReadOnly] =
      scala
        .Option(impl.awsApiGatewayV2Api())
        .map(value =>
          zio.aws.securityhub.model.AwsApiGatewayV2ApiDetails.wrap(value)
        )
    override val awsDynamoDbTable
        : Option[zio.aws.securityhub.model.AwsDynamoDbTableDetails.ReadOnly] =
      scala
        .Option(impl.awsDynamoDbTable())
        .map(value =>
          zio.aws.securityhub.model.AwsDynamoDbTableDetails.wrap(value)
        )
    override val awsApiGatewayStage
        : Option[zio.aws.securityhub.model.AwsApiGatewayStageDetails.ReadOnly] =
      scala
        .Option(impl.awsApiGatewayStage())
        .map(value =>
          zio.aws.securityhub.model.AwsApiGatewayStageDetails.wrap(value)
        )
    override val awsApiGatewayRestApi: Option[
      zio.aws.securityhub.model.AwsApiGatewayRestApiDetails.ReadOnly
    ] = scala
      .Option(impl.awsApiGatewayRestApi())
      .map(value =>
        zio.aws.securityhub.model.AwsApiGatewayRestApiDetails.wrap(value)
      )
    override val awsCloudTrailTrail
        : Option[zio.aws.securityhub.model.AwsCloudTrailTrailDetails.ReadOnly] =
      scala
        .Option(impl.awsCloudTrailTrail())
        .map(value =>
          zio.aws.securityhub.model.AwsCloudTrailTrailDetails.wrap(value)
        )
    override val awsSsmPatchCompliance: Option[
      zio.aws.securityhub.model.AwsSsmPatchComplianceDetails.ReadOnly
    ] = scala
      .Option(impl.awsSsmPatchCompliance())
      .map(value =>
        zio.aws.securityhub.model.AwsSsmPatchComplianceDetails.wrap(value)
      )
    override val awsCertificateManagerCertificate: Option[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDetails.ReadOnly
    ] = scala
      .Option(impl.awsCertificateManagerCertificate())
      .map(value =>
        zio.aws.securityhub.model.AwsCertificateManagerCertificateDetails
          .wrap(value)
      )
    override val awsRedshiftCluster
        : Option[zio.aws.securityhub.model.AwsRedshiftClusterDetails.ReadOnly] =
      scala
        .Option(impl.awsRedshiftCluster())
        .map(value =>
          zio.aws.securityhub.model.AwsRedshiftClusterDetails.wrap(value)
        )
    override val awsElbLoadBalancer
        : Option[zio.aws.securityhub.model.AwsElbLoadBalancerDetails.ReadOnly] =
      scala
        .Option(impl.awsElbLoadBalancer())
        .map(value =>
          zio.aws.securityhub.model.AwsElbLoadBalancerDetails.wrap(value)
        )
    override val awsIamGroup
        : Option[zio.aws.securityhub.model.AwsIamGroupDetails.ReadOnly] = scala
      .Option(impl.awsIamGroup())
      .map(value => zio.aws.securityhub.model.AwsIamGroupDetails.wrap(value))
    override val awsIamRole
        : Option[zio.aws.securityhub.model.AwsIamRoleDetails.ReadOnly] = scala
      .Option(impl.awsIamRole())
      .map(value => zio.aws.securityhub.model.AwsIamRoleDetails.wrap(value))
    override val awsKmsKey
        : Option[zio.aws.securityhub.model.AwsKmsKeyDetails.ReadOnly] = scala
      .Option(impl.awsKmsKey())
      .map(value => zio.aws.securityhub.model.AwsKmsKeyDetails.wrap(value))
    override val awsLambdaFunction
        : Option[zio.aws.securityhub.model.AwsLambdaFunctionDetails.ReadOnly] =
      scala
        .Option(impl.awsLambdaFunction())
        .map(value =>
          zio.aws.securityhub.model.AwsLambdaFunctionDetails.wrap(value)
        )
    override val awsLambdaLayerVersion: Option[
      zio.aws.securityhub.model.AwsLambdaLayerVersionDetails.ReadOnly
    ] = scala
      .Option(impl.awsLambdaLayerVersion())
      .map(value =>
        zio.aws.securityhub.model.AwsLambdaLayerVersionDetails.wrap(value)
      )
    override val awsRdsDbInstance
        : Option[zio.aws.securityhub.model.AwsRdsDbInstanceDetails.ReadOnly] =
      scala
        .Option(impl.awsRdsDbInstance())
        .map(value =>
          zio.aws.securityhub.model.AwsRdsDbInstanceDetails.wrap(value)
        )
    override val awsSnsTopic
        : Option[zio.aws.securityhub.model.AwsSnsTopicDetails.ReadOnly] = scala
      .Option(impl.awsSnsTopic())
      .map(value => zio.aws.securityhub.model.AwsSnsTopicDetails.wrap(value))
    override val awsSqsQueue
        : Option[zio.aws.securityhub.model.AwsSqsQueueDetails.ReadOnly] = scala
      .Option(impl.awsSqsQueue())
      .map(value => zio.aws.securityhub.model.AwsSqsQueueDetails.wrap(value))
    override val awsWafWebAcl
        : Option[zio.aws.securityhub.model.AwsWafWebAclDetails.ReadOnly] = scala
      .Option(impl.awsWafWebAcl())
      .map(value => zio.aws.securityhub.model.AwsWafWebAclDetails.wrap(value))
    override val awsRdsDbSnapshot
        : Option[zio.aws.securityhub.model.AwsRdsDbSnapshotDetails.ReadOnly] =
      scala
        .Option(impl.awsRdsDbSnapshot())
        .map(value =>
          zio.aws.securityhub.model.AwsRdsDbSnapshotDetails.wrap(value)
        )
    override val awsRdsDbClusterSnapshot: Option[
      zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDetails.ReadOnly
    ] = scala
      .Option(impl.awsRdsDbClusterSnapshot())
      .map(value =>
        zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDetails.wrap(value)
      )
    override val awsRdsDbCluster
        : Option[zio.aws.securityhub.model.AwsRdsDbClusterDetails.ReadOnly] =
      scala
        .Option(impl.awsRdsDbCluster())
        .map(value =>
          zio.aws.securityhub.model.AwsRdsDbClusterDetails.wrap(value)
        )
    override val awsEcsCluster
        : Option[zio.aws.securityhub.model.AwsEcsClusterDetails.ReadOnly] =
      scala
        .Option(impl.awsEcsCluster())
        .map(value =>
          zio.aws.securityhub.model.AwsEcsClusterDetails.wrap(value)
        )
    override val awsEcsTaskDefinition: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionDetails.ReadOnly
    ] = scala
      .Option(impl.awsEcsTaskDefinition())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionDetails.wrap(value)
      )
    override val container
        : Option[zio.aws.securityhub.model.ContainerDetails.ReadOnly] = scala
      .Option(impl.container())
      .map(value => zio.aws.securityhub.model.ContainerDetails.wrap(value))
    override val other: Option[Map[NonEmptyString, NonEmptyString]] = scala
      .Option(impl.other())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.securityhub.model.primitives.NonEmptyString(
              key
            ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
          })
          .toMap
      )
    override val awsRdsEventSubscription: Option[
      zio.aws.securityhub.model.AwsRdsEventSubscriptionDetails.ReadOnly
    ] = scala
      .Option(impl.awsRdsEventSubscription())
      .map(value =>
        zio.aws.securityhub.model.AwsRdsEventSubscriptionDetails.wrap(value)
      )
    override val awsEcsService
        : Option[zio.aws.securityhub.model.AwsEcsServiceDetails.ReadOnly] =
      scala
        .Option(impl.awsEcsService())
        .map(value =>
          zio.aws.securityhub.model.AwsEcsServiceDetails.wrap(value)
        )
    override val awsAutoScalingLaunchConfiguration: Option[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationDetails.ReadOnly
    ] = scala
      .Option(impl.awsAutoScalingLaunchConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationDetails
          .wrap(value)
      )
    override val awsEc2VpnConnection: Option[
      zio.aws.securityhub.model.AwsEc2VpnConnectionDetails.ReadOnly
    ] = scala
      .Option(impl.awsEc2VpnConnection())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2VpnConnectionDetails.wrap(value)
      )
    override val awsEcrContainerImage: Option[
      zio.aws.securityhub.model.AwsEcrContainerImageDetails.ReadOnly
    ] = scala
      .Option(impl.awsEcrContainerImage())
      .map(value =>
        zio.aws.securityhub.model.AwsEcrContainerImageDetails.wrap(value)
      )
    override val awsOpenSearchServiceDomain: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainDetails.ReadOnly
    ] = scala
      .Option(impl.awsOpenSearchServiceDomain())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainDetails.wrap(value)
      )
    override val awsEc2VpcEndpointService: Option[
      zio.aws.securityhub.model.AwsEc2VpcEndpointServiceDetails.ReadOnly
    ] = scala
      .Option(impl.awsEc2VpcEndpointService())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2VpcEndpointServiceDetails.wrap(value)
      )
    override val awsXrayEncryptionConfig: Option[
      zio.aws.securityhub.model.AwsXrayEncryptionConfigDetails.ReadOnly
    ] = scala
      .Option(impl.awsXrayEncryptionConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsXrayEncryptionConfigDetails.wrap(value)
      )
    override val awsWafRateBasedRule: Option[
      zio.aws.securityhub.model.AwsWafRateBasedRuleDetails.ReadOnly
    ] = scala
      .Option(impl.awsWafRateBasedRule())
      .map(value =>
        zio.aws.securityhub.model.AwsWafRateBasedRuleDetails.wrap(value)
      )
    override val awsWafRegionalRateBasedRule: Option[
      zio.aws.securityhub.model.AwsWafRegionalRateBasedRuleDetails.ReadOnly
    ] = scala
      .Option(impl.awsWafRegionalRateBasedRule())
      .map(value =>
        zio.aws.securityhub.model.AwsWafRegionalRateBasedRuleDetails.wrap(value)
      )
    override val awsEcrRepository
        : Option[zio.aws.securityhub.model.AwsEcrRepositoryDetails.ReadOnly] =
      scala
        .Option(impl.awsEcrRepository())
        .map(value =>
          zio.aws.securityhub.model.AwsEcrRepositoryDetails.wrap(value)
        )
    override val awsEksCluster
        : Option[zio.aws.securityhub.model.AwsEksClusterDetails.ReadOnly] =
      scala
        .Option(impl.awsEksCluster())
        .map(value =>
          zio.aws.securityhub.model.AwsEksClusterDetails.wrap(value)
        )
    override val awsNetworkFirewallFirewallPolicy: Option[
      zio.aws.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails.ReadOnly
    ] = scala
      .Option(impl.awsNetworkFirewallFirewallPolicy())
      .map(value =>
        zio.aws.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails
          .wrap(value)
      )
    override val awsNetworkFirewallFirewall: Option[
      zio.aws.securityhub.model.AwsNetworkFirewallFirewallDetails.ReadOnly
    ] = scala
      .Option(impl.awsNetworkFirewallFirewall())
      .map(value =>
        zio.aws.securityhub.model.AwsNetworkFirewallFirewallDetails.wrap(value)
      )
    override val awsNetworkFirewallRuleGroup: Option[
      zio.aws.securityhub.model.AwsNetworkFirewallRuleGroupDetails.ReadOnly
    ] = scala
      .Option(impl.awsNetworkFirewallRuleGroup())
      .map(value =>
        zio.aws.securityhub.model.AwsNetworkFirewallRuleGroupDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ResourceDetails
  ): zio.aws.securityhub.model.ResourceDetails.ReadOnly = new Wrapper(impl)
}
