package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MapFilter(
    key: Option[NonEmptyString] = None,
    value: Option[NonEmptyString] = None,
    comparison: Option[zio.aws.securityhub.model.MapFilterComparison] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.MapFilter = {
    import MapFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.MapFilter
      .builder()
      .optionallyWith(
        key.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(comparison.map(value => value.unwrap))(_.comparison)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.MapFilter.ReadOnly =
    zio.aws.securityhub.model.MapFilter.wrap(buildAwsValue())
}
object MapFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.MapFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.MapFilter =
      zio.aws.securityhub.model.MapFilter(
        key.map(value => value),
        value.map(value => value),
        comparison.map(value => value)
      )
    def key: Option[NonEmptyString]
    def value: Option[NonEmptyString]
    def comparison: Option[zio.aws.securityhub.model.MapFilterComparison]
    def getKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
    def getComparison
        : ZIO[Any, AwsError, zio.aws.securityhub.model.MapFilterComparison] =
      AwsError.unwrapOptionField("comparison", comparison)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.MapFilter
  ) extends zio.aws.securityhub.model.MapFilter.ReadOnly {
    override val key: Option[NonEmptyString] = scala
      .Option(impl.key())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val value: Option[NonEmptyString] = scala
      .Option(impl.value())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val comparison
        : Option[zio.aws.securityhub.model.MapFilterComparison] = scala
      .Option(impl.comparison())
      .map(value => zio.aws.securityhub.model.MapFilterComparison.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.MapFilter
  ): zio.aws.securityhub.model.MapFilter.ReadOnly = new Wrapper(impl)
}
