package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetMembersResponse(
    members: Option[Iterable[zio.aws.securityhub.model.Member]] = None,
    unprocessedAccounts: Option[Iterable[zio.aws.securityhub.model.Result]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.GetMembersResponse = {
    import GetMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.GetMembersResponse
      .builder()
      .optionallyWith(
        members.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.members)
      .optionallyWith(
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedAccounts)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.GetMembersResponse.ReadOnly =
    zio.aws.securityhub.model.GetMembersResponse.wrap(buildAwsValue())
}
object GetMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.GetMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.GetMembersResponse =
      zio.aws.securityhub.model.GetMembersResponse(
        members.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def members: Option[List[zio.aws.securityhub.model.Member.ReadOnly]]
    def unprocessedAccounts
        : Option[List[zio.aws.securityhub.model.Result.ReadOnly]]
    def getMembers
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.Member.ReadOnly]] =
      AwsError.unwrapOptionField("members", members)
    def getUnprocessedAccounts
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.Result.ReadOnly]] =
      AwsError.unwrapOptionField("unprocessedAccounts", unprocessedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.GetMembersResponse
  ) extends zio.aws.securityhub.model.GetMembersResponse.ReadOnly {
    override val members
        : Option[List[zio.aws.securityhub.model.Member.ReadOnly]] = scala
      .Option(impl.members())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.Member.wrap(item)
        }.toList
      )
    override val unprocessedAccounts
        : Option[List[zio.aws.securityhub.model.Result.ReadOnly]] = scala
      .Option(impl.unprocessedAccounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.Result.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.GetMembersResponse
  ): zio.aws.securityhub.model.GetMembersResponse.ReadOnly = new Wrapper(impl)
}
