package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetEnabledStandardsResponse(
    standardsSubscriptions: Option[
      Iterable[zio.aws.securityhub.model.StandardsSubscription]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse = {
    import GetEnabledStandardsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse
      .builder()
      .optionallyWith(
        standardsSubscriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.standardsSubscriptions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.GetEnabledStandardsResponse.ReadOnly =
    zio.aws.securityhub.model.GetEnabledStandardsResponse.wrap(buildAwsValue())
}
object GetEnabledStandardsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.GetEnabledStandardsResponse =
      zio.aws.securityhub.model.GetEnabledStandardsResponse(
        standardsSubscriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def standardsSubscriptions
        : Option[List[zio.aws.securityhub.model.StandardsSubscription.ReadOnly]]
    def nextToken: Option[NextToken]
    def getStandardsSubscriptions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StandardsSubscription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "standardsSubscriptions",
      standardsSubscriptions
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse
  ) extends zio.aws.securityhub.model.GetEnabledStandardsResponse.ReadOnly {
    override val standardsSubscriptions: Option[
      List[zio.aws.securityhub.model.StandardsSubscription.ReadOnly]
    ] = scala
      .Option(impl.standardsSubscriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StandardsSubscription.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse
  ): zio.aws.securityhub.model.GetEnabledStandardsResponse.ReadOnly =
    new Wrapper(impl)
}
