package zio.aws.securityhub.model
import java.lang.Integer
import zio.ZIO
import zio.aws.securityhub.model.primitives.{
  MaxResults,
  NextToken,
  NonEmptyString
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetEnabledStandardsRequest(
    standardsSubscriptionArns: Option[Iterable[NonEmptyString]] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest = {
    import GetEnabledStandardsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest
      .builder()
      .optionallyWith(
        standardsSubscriptionArns.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.standardsSubscriptionArns)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.GetEnabledStandardsRequest.ReadOnly =
    zio.aws.securityhub.model.GetEnabledStandardsRequest.wrap(buildAwsValue())
}
object GetEnabledStandardsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.GetEnabledStandardsRequest =
      zio.aws.securityhub.model.GetEnabledStandardsRequest(
        standardsSubscriptionArns.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def standardsSubscriptionArns: Option[List[NonEmptyString]]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getStandardsSubscriptionArns: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "standardsSubscriptionArns",
        standardsSubscriptionArns
      )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest
  ) extends zio.aws.securityhub.model.GetEnabledStandardsRequest.ReadOnly {
    override val standardsSubscriptionArns: Option[List[NonEmptyString]] = scala
      .Option(impl.standardsSubscriptionArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.securityhub.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest
  ): zio.aws.securityhub.model.GetEnabledStandardsRequest.ReadOnly =
    new Wrapper(impl)
}
