package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EnableImportFindingsForProductResponse(
    productSubscriptionArn: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductResponse = {
    import EnableImportFindingsForProductResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductResponse
      .builder()
      .optionallyWith(
        productSubscriptionArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.productSubscriptionArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.EnableImportFindingsForProductResponse.ReadOnly =
    zio.aws.securityhub.model.EnableImportFindingsForProductResponse
      .wrap(buildAwsValue())
}
object EnableImportFindingsForProductResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.EnableImportFindingsForProductResponse =
      zio.aws.securityhub.model.EnableImportFindingsForProductResponse(
        productSubscriptionArn.map(value => value)
      )
    def productSubscriptionArn: Option[NonEmptyString]
    def getProductSubscriptionArn: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("productSubscriptionArn", productSubscriptionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductResponse
  ) extends zio.aws.securityhub.model.EnableImportFindingsForProductResponse.ReadOnly {
    override val productSubscriptionArn: Option[NonEmptyString] = scala
      .Option(impl.productSubscriptionArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductResponse
  ): zio.aws.securityhub.model.EnableImportFindingsForProductResponse.ReadOnly =
    new Wrapper(impl)
}
