package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisableOrganizationAdminAccountRequest(
    adminAccountId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DisableOrganizationAdminAccountRequest = {
    import DisableOrganizationAdminAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DisableOrganizationAdminAccountRequest
      .builder()
      .adminAccountId(NonEmptyString.unwrap(adminAccountId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.DisableOrganizationAdminAccountRequest.ReadOnly =
    zio.aws.securityhub.model.DisableOrganizationAdminAccountRequest
      .wrap(buildAwsValue())
}
object DisableOrganizationAdminAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DisableOrganizationAdminAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.DisableOrganizationAdminAccountRequest =
      zio.aws.securityhub.model
        .DisableOrganizationAdminAccountRequest(adminAccountId)
    def adminAccountId: NonEmptyString
    def getAdminAccountId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(adminAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DisableOrganizationAdminAccountRequest
  ) extends zio.aws.securityhub.model.DisableOrganizationAdminAccountRequest.ReadOnly {
    override val adminAccountId: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.adminAccountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DisableOrganizationAdminAccountRequest
  ): zio.aws.securityhub.model.DisableOrganizationAdminAccountRequest.ReadOnly =
    new Wrapper(impl)
}
