package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeHubResponse(
    hubArn: Option[NonEmptyString] = None,
    subscribedAt: Option[NonEmptyString] = None,
    autoEnableControls: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DescribeHubResponse = {
    import DescribeHubResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DescribeHubResponse
      .builder()
      .optionallyWith(
        hubArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.hubArn)
      .optionallyWith(
        subscribedAt.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.subscribedAt)
      .optionallyWith(
        autoEnableControls.map(value => value: java.lang.Boolean)
      )(_.autoEnableControls)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.DescribeHubResponse.ReadOnly =
    zio.aws.securityhub.model.DescribeHubResponse.wrap(buildAwsValue())
}
object DescribeHubResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DescribeHubResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DescribeHubResponse =
      zio.aws.securityhub.model.DescribeHubResponse(
        hubArn.map(value => value),
        subscribedAt.map(value => value),
        autoEnableControls.map(value => value)
      )
    def hubArn: Option[NonEmptyString]
    def subscribedAt: Option[NonEmptyString]
    def autoEnableControls: Option[Boolean]
    def getHubArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("hubArn", hubArn)
    def getSubscribedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subscribedAt", subscribedAt)
    def getAutoEnableControls: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoEnableControls", autoEnableControls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeHubResponse
  ) extends zio.aws.securityhub.model.DescribeHubResponse.ReadOnly {
    override val hubArn: Option[NonEmptyString] = scala
      .Option(impl.hubArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val subscribedAt: Option[NonEmptyString] = scala
      .Option(impl.subscribedAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val autoEnableControls: Option[Boolean] =
      scala.Option(impl.autoEnableControls()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeHubResponse
  ): zio.aws.securityhub.model.DescribeHubResponse.ReadOnly = new Wrapper(impl)
}
