package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteInsightRequest(insightArn: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DeleteInsightRequest = {
    import DeleteInsightRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DeleteInsightRequest
      .builder()
      .insightArn(NonEmptyString.unwrap(insightArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.DeleteInsightRequest.ReadOnly =
    zio.aws.securityhub.model.DeleteInsightRequest.wrap(buildAwsValue())
}
object DeleteInsightRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DeleteInsightRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DeleteInsightRequest =
      zio.aws.securityhub.model.DeleteInsightRequest(insightArn)
    def insightArn: NonEmptyString
    def getInsightArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(insightArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DeleteInsightRequest
  ) extends zio.aws.securityhub.model.DeleteInsightRequest.ReadOnly {
    override val insightArn: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.insightArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DeleteInsightRequest
  ): zio.aws.securityhub.model.DeleteInsightRequest.ReadOnly = new Wrapper(impl)
}
