package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeclineInvitationsRequest(
    accountIds: Iterable[NonEmptyString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DeclineInvitationsRequest = {
    import DeclineInvitationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DeclineInvitationsRequest
      .builder()
      .accountIds(accountIds.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.DeclineInvitationsRequest.ReadOnly =
    zio.aws.securityhub.model.DeclineInvitationsRequest.wrap(buildAwsValue())
}
object DeclineInvitationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DeclineInvitationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DeclineInvitationsRequest =
      zio.aws.securityhub.model.DeclineInvitationsRequest(accountIds)
    def accountIds: List[NonEmptyString]
    def getAccountIds: ZIO[Any, Nothing, List[NonEmptyString]] =
      ZIO.succeed(accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DeclineInvitationsRequest
  ) extends zio.aws.securityhub.model.DeclineInvitationsRequest.ReadOnly {
    override val accountIds: List[NonEmptyString] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.primitives.NonEmptyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DeclineInvitationsRequest
  ): zio.aws.securityhub.model.DeclineInvitationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
