package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CustomDataIdentifiersDetections(
    count: Option[Long] = None,
    arn: Option[NonEmptyString] = None,
    name: Option[NonEmptyString] = None,
    occurrences: Option[zio.aws.securityhub.model.Occurrences] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersDetections = {
    import CustomDataIdentifiersDetections.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersDetections
      .builder()
      .optionallyWith(count.map(value => value: java.lang.Long))(_.count)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(occurrences.map(value => value.buildAwsValue()))(
        _.occurrences
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.CustomDataIdentifiersDetections.ReadOnly =
    zio.aws.securityhub.model.CustomDataIdentifiersDetections
      .wrap(buildAwsValue())
}
object CustomDataIdentifiersDetections {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersDetections
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.CustomDataIdentifiersDetections =
      zio.aws.securityhub.model.CustomDataIdentifiersDetections(
        count.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        occurrences.map(value => value.asEditable)
      )
    def count: Option[Long]
    def arn: Option[NonEmptyString]
    def name: Option[NonEmptyString]
    def occurrences: Option[zio.aws.securityhub.model.Occurrences.ReadOnly]
    def getCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("count", count)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getOccurrences
        : ZIO[Any, AwsError, zio.aws.securityhub.model.Occurrences.ReadOnly] =
      AwsError.unwrapOptionField("occurrences", occurrences)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersDetections
  ) extends zio.aws.securityhub.model.CustomDataIdentifiersDetections.ReadOnly {
    override val count: Option[Long] =
      scala.Option(impl.count()).map(value => value: Long)
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val occurrences
        : Option[zio.aws.securityhub.model.Occurrences.ReadOnly] = scala
      .Option(impl.occurrences())
      .map(value => zio.aws.securityhub.model.Occurrences.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersDetections
  ): zio.aws.securityhub.model.CustomDataIdentifiersDetections.ReadOnly =
    new Wrapper(impl)
}
