package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateMembersRequest(
    accountDetails: Iterable[zio.aws.securityhub.model.AccountDetails]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.CreateMembersRequest = {
    import CreateMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.CreateMembersRequest
      .builder()
      .accountDetails(accountDetails.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.CreateMembersRequest.ReadOnly =
    zio.aws.securityhub.model.CreateMembersRequest.wrap(buildAwsValue())
}
object CreateMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.CreateMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.CreateMembersRequest =
      zio.aws.securityhub.model.CreateMembersRequest(accountDetails.map {
        item =>
          item.asEditable
      })
    def accountDetails: List[zio.aws.securityhub.model.AccountDetails.ReadOnly]
    def getAccountDetails: ZIO[Any, Nothing, List[
      zio.aws.securityhub.model.AccountDetails.ReadOnly
    ]] = ZIO.succeed(accountDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.CreateMembersRequest
  ) extends zio.aws.securityhub.model.CreateMembersRequest.ReadOnly {
    override val accountDetails
        : List[zio.aws.securityhub.model.AccountDetails.ReadOnly] = impl
      .accountDetails()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.AccountDetails.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.CreateMembersRequest
  ): zio.aws.securityhub.model.CreateMembersRequest.ReadOnly = new Wrapper(impl)
}
