package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Country(
    countryCode: Option[NonEmptyString] = None,
    countryName: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Country = {
    import Country.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Country
      .builder()
      .optionallyWith(
        countryCode.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.countryCode)
      .optionallyWith(
        countryName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.countryName)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Country.ReadOnly =
    zio.aws.securityhub.model.Country.wrap(buildAwsValue())
}
object Country {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Country
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Country =
      zio.aws.securityhub.model.Country(
        countryCode.map(value => value),
        countryName.map(value => value)
      )
    def countryCode: Option[NonEmptyString]
    def countryName: Option[NonEmptyString]
    def getCountryCode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("countryCode", countryCode)
    def getCountryName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("countryName", countryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Country
  ) extends zio.aws.securityhub.model.Country.ReadOnly {
    override val countryCode: Option[NonEmptyString] = scala
      .Option(impl.countryCode())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val countryName: Option[NonEmptyString] = scala
      .Option(impl.countryName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Country
  ): zio.aws.securityhub.model.Country.ReadOnly = new Wrapper(impl)
}
