package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsS3ObjectDetails(
    lastModified: Option[NonEmptyString] = None,
    eTag: Option[NonEmptyString] = None,
    versionId: Option[NonEmptyString] = None,
    contentType: Option[NonEmptyString] = None,
    serverSideEncryption: Option[NonEmptyString] = None,
    ssekmsKeyId: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3ObjectDetails = {
    import AwsS3ObjectDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3ObjectDetails
      .builder()
      .optionallyWith(
        lastModified.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastModified)
      .optionallyWith(
        eTag.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.eTag)
      .optionallyWith(
        versionId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        contentType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        serverSideEncryption.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.serverSideEncryption)
      .optionallyWith(
        ssekmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ssekmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsS3ObjectDetails.ReadOnly =
    zio.aws.securityhub.model.AwsS3ObjectDetails.wrap(buildAwsValue())
}
object AwsS3ObjectDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3ObjectDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsS3ObjectDetails =
      zio.aws.securityhub.model.AwsS3ObjectDetails(
        lastModified.map(value => value),
        eTag.map(value => value),
        versionId.map(value => value),
        contentType.map(value => value),
        serverSideEncryption.map(value => value),
        ssekmsKeyId.map(value => value)
      )
    def lastModified: Option[NonEmptyString]
    def eTag: Option[NonEmptyString]
    def versionId: Option[NonEmptyString]
    def contentType: Option[NonEmptyString]
    def serverSideEncryption: Option[NonEmptyString]
    def ssekmsKeyId: Option[NonEmptyString]
    def getLastModified: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getETag: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getVersionId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getContentType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getServerSideEncryption: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serverSideEncryption", serverSideEncryption)
    def getSsekmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3ObjectDetails
  ) extends zio.aws.securityhub.model.AwsS3ObjectDetails.ReadOnly {
    override val lastModified: Option[NonEmptyString] = scala
      .Option(impl.lastModified())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val eTag: Option[NonEmptyString] = scala
      .Option(impl.eTag())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val versionId: Option[NonEmptyString] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val contentType: Option[NonEmptyString] = scala
      .Option(impl.contentType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val serverSideEncryption: Option[NonEmptyString] = scala
      .Option(impl.serverSideEncryption())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ssekmsKeyId: Option[NonEmptyString] = scala
      .Option(impl.ssekmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3ObjectDetails
  ): zio.aws.securityhub.model.AwsS3ObjectDetails.ReadOnly = new Wrapper(impl)
}
