package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsS3BucketWebsiteConfigurationRoutingRuleCondition(
    httpErrorCodeReturnedEquals: Option[NonEmptyString] = None,
    keyPrefixEquals: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition = {
    import AwsS3BucketWebsiteConfigurationRoutingRuleCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition
      .builder()
      .optionallyWith(
        httpErrorCodeReturnedEquals.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.httpErrorCodeReturnedEquals)
      .optionallyWith(
        keyPrefixEquals.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.keyPrefixEquals)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition
      .wrap(buildAwsValue())
}
object AwsS3BucketWebsiteConfigurationRoutingRuleCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition =
      zio.aws.securityhub.model
        .AwsS3BucketWebsiteConfigurationRoutingRuleCondition(
          httpErrorCodeReturnedEquals.map(value => value),
          keyPrefixEquals.map(value => value)
        )
    def httpErrorCodeReturnedEquals: Option[NonEmptyString]
    def keyPrefixEquals: Option[NonEmptyString]
    def getHttpErrorCodeReturnedEquals: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "httpErrorCodeReturnedEquals",
        httpErrorCodeReturnedEquals
      )
    def getKeyPrefixEquals: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyPrefixEquals", keyPrefixEquals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition
  ) extends zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition.ReadOnly {
    override val httpErrorCodeReturnedEquals: Option[NonEmptyString] = scala
      .Option(impl.httpErrorCodeReturnedEquals())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val keyPrefixEquals: Option[NonEmptyString] = scala
      .Option(impl.keyPrefixEquals())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition
  ): zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition.ReadOnly =
    new Wrapper(impl)
}
