package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsS3BucketNotificationConfiguration(
    configurations: Option[Iterable[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationDetail
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfiguration = {
    import AwsS3BucketNotificationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfiguration
      .builder()
      .optionallyWith(
        configurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurations)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketNotificationConfiguration.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketNotificationConfiguration
      .wrap(buildAwsValue())
}
object AwsS3BucketNotificationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketNotificationConfiguration =
      zio.aws.securityhub.model.AwsS3BucketNotificationConfiguration(
        configurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def configurations: Option[List[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationDetail.ReadOnly
    ]]
    def getConfigurations: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("configurations", configurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfiguration
  ) extends zio.aws.securityhub.model.AwsS3BucketNotificationConfiguration.ReadOnly {
    override val configurations: Option[List[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationDetail.ReadOnly
    ]] = scala
      .Option(impl.configurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationDetail
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfiguration
  ): zio.aws.securityhub.model.AwsS3BucketNotificationConfiguration.ReadOnly =
    new Wrapper(impl)
}
