package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails(
    predicate: Option[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails = {
    import AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails
      .builder()
      .optionallyWith(predicate.map(value => value.buildAwsValue()))(
        _.predicate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails
      .wrap(buildAwsValue())
}
object AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails =
      zio.aws.securityhub.model
        .AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails(
          predicate.map(value => value.asEditable)
        )
    def predicate: Option[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.ReadOnly
    ]
    def getPredicate: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.ReadOnly
    ] = AwsError.unwrapOptionField("predicate", predicate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails
  ) extends zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails.ReadOnly {
    override val predicate: Option[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.ReadOnly
    ] = scala
      .Option(impl.predicate())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails
  ): zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails.ReadOnly =
    new Wrapper(impl)
}
