package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterVpcSecurityGroup(
    status: Option[NonEmptyString] = None,
    vpcSecurityGroupId: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterVpcSecurityGroup = {
    import AwsRedshiftClusterVpcSecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterVpcSecurityGroup
      .builder()
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        vpcSecurityGroupId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.vpcSecurityGroupId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup
      .wrap(buildAwsValue())
}
object AwsRedshiftClusterVpcSecurityGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterVpcSecurityGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup =
      zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup(
        status.map(value => value),
        vpcSecurityGroupId.map(value => value)
      )
    def status: Option[NonEmptyString]
    def vpcSecurityGroupId: Option[NonEmptyString]
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getVpcSecurityGroupId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcSecurityGroupId", vpcSecurityGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterVpcSecurityGroup
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup.ReadOnly {
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vpcSecurityGroupId: Option[NonEmptyString] = scala
      .Option(impl.vpcSecurityGroupId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterVpcSecurityGroup
  ): zio.aws.securityhub.model.AwsRedshiftClusterVpcSecurityGroup.ReadOnly =
    new Wrapper(impl)
}
