package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterClusterSecurityGroup(
    clusterSecurityGroupName: Option[NonEmptyString] = None,
    status: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterSecurityGroup = {
    import AwsRedshiftClusterClusterSecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterSecurityGroup
      .builder()
      .optionallyWith(
        clusterSecurityGroupName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterSecurityGroupName)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRedshiftClusterClusterSecurityGroup.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterClusterSecurityGroup
      .wrap(buildAwsValue())
}
object AwsRedshiftClusterClusterSecurityGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterSecurityGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsRedshiftClusterClusterSecurityGroup =
      zio.aws.securityhub.model.AwsRedshiftClusterClusterSecurityGroup(
        clusterSecurityGroupName.map(value => value),
        status.map(value => value)
      )
    def clusterSecurityGroupName: Option[NonEmptyString]
    def status: Option[NonEmptyString]
    def getClusterSecurityGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "clusterSecurityGroupName",
        clusterSecurityGroupName
      )
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterSecurityGroup
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterClusterSecurityGroup.ReadOnly {
    override val clusterSecurityGroupName: Option[NonEmptyString] = scala
      .Option(impl.clusterSecurityGroupName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterSecurityGroup
  ): zio.aws.securityhub.model.AwsRedshiftClusterClusterSecurityGroup.ReadOnly =
    new Wrapper(impl)
}
