package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterClusterParameterStatus(
    parameterName: Option[NonEmptyString] = None,
    parameterApplyStatus: Option[NonEmptyString] = None,
    parameterApplyErrorDescription: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterStatus = {
    import AwsRedshiftClusterClusterParameterStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterStatus
      .builder()
      .optionallyWith(
        parameterName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.parameterName)
      .optionallyWith(
        parameterApplyStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.parameterApplyStatus)
      .optionallyWith(
        parameterApplyErrorDescription.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.parameterApplyErrorDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterStatus.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterStatus
      .wrap(buildAwsValue())
}
object AwsRedshiftClusterClusterParameterStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterStatus =
      zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterStatus(
        parameterName.map(value => value),
        parameterApplyStatus.map(value => value),
        parameterApplyErrorDescription.map(value => value)
      )
    def parameterName: Option[NonEmptyString]
    def parameterApplyStatus: Option[NonEmptyString]
    def parameterApplyErrorDescription: Option[NonEmptyString]
    def getParameterName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("parameterName", parameterName)
    def getParameterApplyStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("parameterApplyStatus", parameterApplyStatus)
    def getParameterApplyErrorDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "parameterApplyErrorDescription",
        parameterApplyErrorDescription
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterStatus
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterStatus.ReadOnly {
    override val parameterName: Option[NonEmptyString] = scala
      .Option(impl.parameterName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val parameterApplyStatus: Option[NonEmptyString] = scala
      .Option(impl.parameterApplyStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val parameterApplyErrorDescription: Option[NonEmptyString] = scala
      .Option(impl.parameterApplyErrorDescription())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterStatus
  ): zio.aws.securityhub.model.AwsRedshiftClusterClusterParameterStatus.ReadOnly =
    new Wrapper(impl)
}
