package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRdsDbProcessorFeature(
    name: Option[NonEmptyString] = None,
    value: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbProcessorFeature = {
    import AwsRdsDbProcessorFeature.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbProcessorFeature
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsRdsDbProcessorFeature.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbProcessorFeature.wrap(buildAwsValue())
}
object AwsRdsDbProcessorFeature {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbProcessorFeature
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbProcessorFeature =
      zio.aws.securityhub.model.AwsRdsDbProcessorFeature(
        name.map(value => value),
        value.map(value => value)
      )
    def name: Option[NonEmptyString]
    def value: Option[NonEmptyString]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbProcessorFeature
  ) extends zio.aws.securityhub.model.AwsRdsDbProcessorFeature.ReadOnly {
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val value: Option[NonEmptyString] = scala
      .Option(impl.value())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbProcessorFeature
  ): zio.aws.securityhub.model.AwsRdsDbProcessorFeature.ReadOnly = new Wrapper(
    impl
  )
}
