package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRdsDbInstanceVpcSecurityGroup(
    vpcSecurityGroupId: Option[NonEmptyString] = None,
    status: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup = {
    import AwsRdsDbInstanceVpcSecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup
      .builder()
      .optionallyWith(
        vpcSecurityGroupId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.vpcSecurityGroupId)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup
      .wrap(buildAwsValue())
}
object AwsRdsDbInstanceVpcSecurityGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup =
      zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup(
        vpcSecurityGroupId.map(value => value),
        status.map(value => value)
      )
    def vpcSecurityGroupId: Option[NonEmptyString]
    def status: Option[NonEmptyString]
    def getVpcSecurityGroupId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcSecurityGroupId", vpcSecurityGroupId)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup
  ) extends zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.ReadOnly {
    override val vpcSecurityGroupId: Option[NonEmptyString] = scala
      .Option(impl.vpcSecurityGroupId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup
  ): zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.ReadOnly =
    new Wrapper(impl)
}
