package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails(
    enabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails = {
    import AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails
      .wrap(buildAwsValue())
}
object AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails =
      zio.aws.securityhub.model
        .AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails(
          enabled.map(value => value)
        )
    def enabled: Option[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails
  ) extends zio.aws.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails
  ): zio.aws.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
