package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsLambdaFunctionEnvironment(
    variables: Option[Map[NonEmptyString, NonEmptyString]] = None,
    error: Option[zio.aws.securityhub.model.AwsLambdaFunctionEnvironmentError] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionEnvironment = {
    import AwsLambdaFunctionEnvironment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionEnvironment
      .builder()
      .optionallyWith(
        variables.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.variables)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsLambdaFunctionEnvironment.ReadOnly =
    zio.aws.securityhub.model.AwsLambdaFunctionEnvironment.wrap(buildAwsValue())
}
object AwsLambdaFunctionEnvironment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionEnvironment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsLambdaFunctionEnvironment =
      zio.aws.securityhub.model.AwsLambdaFunctionEnvironment(
        variables.map(value => value),
        error.map(value => value.asEditable)
      )
    def variables: Option[Map[NonEmptyString, NonEmptyString]]
    def error: Option[
      zio.aws.securityhub.model.AwsLambdaFunctionEnvironmentError.ReadOnly
    ]
    def getVariables: ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("variables", variables)
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsLambdaFunctionEnvironmentError.ReadOnly
    ] = AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionEnvironment
  ) extends zio.aws.securityhub.model.AwsLambdaFunctionEnvironment.ReadOnly {
    override val variables: Option[Map[NonEmptyString, NonEmptyString]] = scala
      .Option(impl.variables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.securityhub.model.primitives.NonEmptyString(
              key
            ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
          })
          .toMap
      )
    override val error: Option[
      zio.aws.securityhub.model.AwsLambdaFunctionEnvironmentError.ReadOnly
    ] = scala
      .Option(impl.error())
      .map(value =>
        zio.aws.securityhub.model.AwsLambdaFunctionEnvironmentError.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionEnvironment
  ): zio.aws.securityhub.model.AwsLambdaFunctionEnvironment.ReadOnly =
    new Wrapper(impl)
}
