package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElbLoadBalancerListener(
    instancePort: Option[Integer] = None,
    instanceProtocol: Option[NonEmptyString] = None,
    loadBalancerPort: Option[Integer] = None,
    protocol: Option[NonEmptyString] = None,
    sslCertificateId: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerListener = {
    import AwsElbLoadBalancerListener.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerListener
      .builder()
      .optionallyWith(
        instancePort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.instancePort)
      .optionallyWith(
        instanceProtocol.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceProtocol)
      .optionallyWith(
        loadBalancerPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.loadBalancerPort)
      .optionallyWith(
        protocol.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.protocol)
      .optionallyWith(
        sslCertificateId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sslCertificateId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElbLoadBalancerListener.ReadOnly =
    zio.aws.securityhub.model.AwsElbLoadBalancerListener.wrap(buildAwsValue())
}
object AwsElbLoadBalancerListener {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerListener
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsElbLoadBalancerListener =
      zio.aws.securityhub.model.AwsElbLoadBalancerListener(
        instancePort.map(value => value),
        instanceProtocol.map(value => value),
        loadBalancerPort.map(value => value),
        protocol.map(value => value),
        sslCertificateId.map(value => value)
      )
    def instancePort: Option[Integer]
    def instanceProtocol: Option[NonEmptyString]
    def loadBalancerPort: Option[Integer]
    def protocol: Option[NonEmptyString]
    def sslCertificateId: Option[NonEmptyString]
    def getInstancePort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instancePort", instancePort)
    def getInstanceProtocol: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceProtocol", instanceProtocol)
    def getLoadBalancerPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("loadBalancerPort", loadBalancerPort)
    def getProtocol: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getSslCertificateId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sslCertificateId", sslCertificateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerListener
  ) extends zio.aws.securityhub.model.AwsElbLoadBalancerListener.ReadOnly {
    override val instancePort: Option[Integer] = scala
      .Option(impl.instancePort())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val instanceProtocol: Option[NonEmptyString] = scala
      .Option(impl.instanceProtocol())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val loadBalancerPort: Option[Integer] = scala
      .Option(impl.loadBalancerPort())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val protocol: Option[NonEmptyString] = scala
      .Option(impl.protocol())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sslCertificateId: Option[NonEmptyString] = scala
      .Option(impl.sslCertificateId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerListener
  ): zio.aws.securityhub.model.AwsElbLoadBalancerListener.ReadOnly =
    new Wrapper(impl)
}
