package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionVolumesHostDetails(
    sourcePath: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesHostDetails = {
    import AwsEcsTaskDefinitionVolumesHostDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesHostDetails
      .builder()
      .optionallyWith(
        sourcePath.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.sourcePath)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesHostDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesHostDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionVolumesHostDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesHostDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesHostDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionVolumesHostDetails(sourcePath.map(value => value))
    def sourcePath: Option[NonEmptyString]
    def getSourcePath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourcePath", sourcePath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesHostDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesHostDetails.ReadOnly {
    override val sourcePath: Option[NonEmptyString] = scala
      .Option(impl.sourcePath())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesHostDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesHostDetails.ReadOnly =
    new Wrapper(impl)
}
