package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionProxyConfigurationDetails(
    containerName: Option[NonEmptyString] = None,
    proxyConfigurationProperties: Option[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails
    ]] = None,
    `type`: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails = {
    import AwsEcsTaskDefinitionProxyConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails
      .builder()
      .optionallyWith(
        containerName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.containerName)
      .optionallyWith(
        proxyConfigurationProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.proxyConfigurationProperties)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionProxyConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails =
      zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails(
        containerName.map(value => value),
        proxyConfigurationProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        `type`.map(value => value)
      )
    def containerName: Option[NonEmptyString]
    def proxyConfigurationProperties: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails.ReadOnly
    ]]
    def `type`: Option[NonEmptyString]
    def getContainerName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("containerName", containerName)
    def getProxyConfigurationProperties: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "proxyConfigurationProperties",
      proxyConfigurationProperties
    )
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails.ReadOnly {
    override val containerName: Option[NonEmptyString] = scala
      .Option(impl.containerName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val proxyConfigurationProperties: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails.ReadOnly
    ]] = scala
      .Option(impl.proxyConfigurationProperties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails
            .wrap(item)
        }.toList
      )
    override val `type`: Option[NonEmptyString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
