package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionInferenceAcceleratorsDetails(
    deviceName: Option[NonEmptyString] = None,
    deviceType: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails = {
    import AwsEcsTaskDefinitionInferenceAcceleratorsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails
      .builder()
      .optionallyWith(
        deviceName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.deviceName)
      .optionallyWith(
        deviceType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.deviceType)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionInferenceAcceleratorsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionInferenceAcceleratorsDetails(
          deviceName.map(value => value),
          deviceType.map(value => value)
        )
    def deviceName: Option[NonEmptyString]
    def deviceType: Option[NonEmptyString]
    def getDeviceName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getDeviceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("deviceType", deviceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails.ReadOnly {
    override val deviceName: Option[NonEmptyString] = scala
      .Option(impl.deviceName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val deviceType: Option[NonEmptyString] = scala
      .Option(impl.deviceType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails.ReadOnly =
    new Wrapper(impl)
}
