package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails(
    hardLimit: Option[Integer] = None,
    name: Option[NonEmptyString] = None,
    softLimit: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails = {
    import AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails
      .builder()
      .optionallyWith(
        hardLimit.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.hardLimit)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        softLimit.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.softLimit)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails(
          hardLimit.map(value => value),
          name.map(value => value),
          softLimit.map(value => value)
        )
    def hardLimit: Option[Integer]
    def name: Option[NonEmptyString]
    def softLimit: Option[Integer]
    def getHardLimit: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("hardLimit", hardLimit)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getSoftLimit: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("softLimit", softLimit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails.ReadOnly {
    override val hardLimit: Option[Integer] = scala
      .Option(impl.hardLimit())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val softLimit: Option[Integer] = scala
      .Option(impl.softLimit())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails.ReadOnly =
    new Wrapper(impl)
}
