package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails(
    containerPath: Option[NonEmptyString] = None,
    readOnly: Option[Boolean] = None,
    sourceVolume: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails = {
    import AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails
      .builder()
      .optionallyWith(
        containerPath.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.containerPath)
      .optionallyWith(readOnly.map(value => value: java.lang.Boolean))(
        _.readOnly
      )
      .optionallyWith(
        sourceVolume.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sourceVolume)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails(
          containerPath.map(value => value),
          readOnly.map(value => value),
          sourceVolume.map(value => value)
        )
    def containerPath: Option[NonEmptyString]
    def readOnly: Option[Boolean]
    def sourceVolume: Option[NonEmptyString]
    def getContainerPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("containerPath", containerPath)
    def getReadOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("readOnly", readOnly)
    def getSourceVolume: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceVolume", sourceVolume)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails.ReadOnly {
    override val containerPath: Option[NonEmptyString] = scala
      .Option(impl.containerPath())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val readOnly: Option[Boolean] =
      scala.Option(impl.readOnly()).map(value => value: Boolean)
    override val sourceVolume: Option[NonEmptyString] = scala
      .Option(impl.sourceVolume())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails.ReadOnly =
    new Wrapper(impl)
}
