package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcrRepositoryLifecyclePolicyDetails(
    lifecyclePolicyText: Option[NonEmptyString] = None,
    registryId: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcrRepositoryLifecyclePolicyDetails = {
    import AwsEcrRepositoryLifecyclePolicyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcrRepositoryLifecyclePolicyDetails
      .builder()
      .optionallyWith(
        lifecyclePolicyText.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lifecyclePolicyText)
      .optionallyWith(
        registryId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.registryId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcrRepositoryLifecyclePolicyDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcrRepositoryLifecyclePolicyDetails
      .wrap(buildAwsValue())
}
object AwsEcrRepositoryLifecyclePolicyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcrRepositoryLifecyclePolicyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcrRepositoryLifecyclePolicyDetails =
      zio.aws.securityhub.model.AwsEcrRepositoryLifecyclePolicyDetails(
        lifecyclePolicyText.map(value => value),
        registryId.map(value => value)
      )
    def lifecyclePolicyText: Option[NonEmptyString]
    def registryId: Option[NonEmptyString]
    def getLifecyclePolicyText: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lifecyclePolicyText", lifecyclePolicyText)
    def getRegistryId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("registryId", registryId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcrRepositoryLifecyclePolicyDetails
  ) extends zio.aws.securityhub.model.AwsEcrRepositoryLifecyclePolicyDetails.ReadOnly {
    override val lifecyclePolicyText: Option[NonEmptyString] = scala
      .Option(impl.lifecyclePolicyText())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val registryId: Option[NonEmptyString] = scala
      .Option(impl.registryId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcrRepositoryLifecyclePolicyDetails
  ): zio.aws.securityhub.model.AwsEcrRepositoryLifecyclePolicyDetails.ReadOnly =
    new Wrapper(impl)
}
