package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcrContainerImageDetails(
    registryId: Option[NonEmptyString] = None,
    repositoryName: Option[NonEmptyString] = None,
    architecture: Option[NonEmptyString] = None,
    imageDigest: Option[NonEmptyString] = None,
    imageTags: Option[Iterable[NonEmptyString]] = None,
    imagePublishedAt: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcrContainerImageDetails = {
    import AwsEcrContainerImageDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcrContainerImageDetails
      .builder()
      .optionallyWith(
        registryId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.registryId)
      .optionallyWith(
        repositoryName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        architecture.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.architecture)
      .optionallyWith(
        imageDigest.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.imageDigest)
      .optionallyWith(
        imageTags.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.imageTags)
      .optionallyWith(
        imagePublishedAt.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.imagePublishedAt)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcrContainerImageDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcrContainerImageDetails.wrap(buildAwsValue())
}
object AwsEcrContainerImageDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcrContainerImageDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEcrContainerImageDetails =
      zio.aws.securityhub.model.AwsEcrContainerImageDetails(
        registryId.map(value => value),
        repositoryName.map(value => value),
        architecture.map(value => value),
        imageDigest.map(value => value),
        imageTags.map(value => value),
        imagePublishedAt.map(value => value)
      )
    def registryId: Option[NonEmptyString]
    def repositoryName: Option[NonEmptyString]
    def architecture: Option[NonEmptyString]
    def imageDigest: Option[NonEmptyString]
    def imageTags: Option[List[NonEmptyString]]
    def imagePublishedAt: Option[NonEmptyString]
    def getRegistryId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("registryId", registryId)
    def getRepositoryName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getArchitecture: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getImageDigest: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("imageDigest", imageDigest)
    def getImageTags: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("imageTags", imageTags)
    def getImagePublishedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("imagePublishedAt", imagePublishedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcrContainerImageDetails
  ) extends zio.aws.securityhub.model.AwsEcrContainerImageDetails.ReadOnly {
    override val registryId: Option[NonEmptyString] = scala
      .Option(impl.registryId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val repositoryName: Option[NonEmptyString] = scala
      .Option(impl.repositoryName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val architecture: Option[NonEmptyString] = scala
      .Option(impl.architecture())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val imageDigest: Option[NonEmptyString] = scala
      .Option(impl.imageDigest())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val imageTags: Option[List[NonEmptyString]] = scala
      .Option(impl.imageTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val imagePublishedAt: Option[NonEmptyString] = scala
      .Option(impl.imagePublishedAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcrContainerImageDetails
  ): zio.aws.securityhub.model.AwsEcrContainerImageDetails.ReadOnly =
    new Wrapper(impl)
}
