package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEc2VpnConnectionRoutesDetails(
    destinationCidrBlock: Option[NonEmptyString] = None,
    state: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionRoutesDetails = {
    import AwsEc2VpnConnectionRoutesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionRoutesDetails
      .builder()
      .optionallyWith(
        destinationCidrBlock.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.destinationCidrBlock)
      .optionallyWith(
        state.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2VpnConnectionRoutesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2VpnConnectionRoutesDetails
      .wrap(buildAwsValue())
}
object AwsEc2VpnConnectionRoutesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionRoutesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2VpnConnectionRoutesDetails =
      zio.aws.securityhub.model.AwsEc2VpnConnectionRoutesDetails(
        destinationCidrBlock.map(value => value),
        state.map(value => value)
      )
    def destinationCidrBlock: Option[NonEmptyString]
    def state: Option[NonEmptyString]
    def getDestinationCidrBlock: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionRoutesDetails
  ) extends zio.aws.securityhub.model.AwsEc2VpnConnectionRoutesDetails.ReadOnly {
    override val destinationCidrBlock: Option[NonEmptyString] = scala
      .Option(impl.destinationCidrBlock())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val state: Option[NonEmptyString] = scala
      .Option(impl.state())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionRoutesDetails
  ): zio.aws.securityhub.model.AwsEc2VpnConnectionRoutesDetails.ReadOnly =
    new Wrapper(impl)
}
