package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEc2VpnConnectionOptionsTunnelOptionsDetails(
    dpdTimeoutSeconds: Option[Integer] = None,
    ikeVersions: Option[Iterable[NonEmptyString]] = None,
    outsideIpAddress: Option[NonEmptyString] = None,
    phase1DhGroupNumbers: Option[Iterable[Integer]] = None,
    phase1EncryptionAlgorithms: Option[Iterable[NonEmptyString]] = None,
    phase1IntegrityAlgorithms: Option[Iterable[NonEmptyString]] = None,
    phase1LifetimeSeconds: Option[Integer] = None,
    phase2DhGroupNumbers: Option[Iterable[Integer]] = None,
    phase2EncryptionAlgorithms: Option[Iterable[NonEmptyString]] = None,
    phase2IntegrityAlgorithms: Option[Iterable[NonEmptyString]] = None,
    phase2LifetimeSeconds: Option[Integer] = None,
    preSharedKey: Option[NonEmptyString] = None,
    rekeyFuzzPercentage: Option[Integer] = None,
    rekeyMarginTimeSeconds: Option[Integer] = None,
    replayWindowSize: Option[Integer] = None,
    tunnelInsideCidr: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails = {
    import AwsEc2VpnConnectionOptionsTunnelOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails
      .builder()
      .optionallyWith(
        dpdTimeoutSeconds.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.dpdTimeoutSeconds)
      .optionallyWith(
        ikeVersions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ikeVersions)
      .optionallyWith(
        outsideIpAddress.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.outsideIpAddress)
      .optionallyWith(
        phase1DhGroupNumbers.map(value =>
          value.map { item =>
            Integer.unwrap(item): java.lang.Integer
          }.asJavaCollection
        )
      )(_.phase1DhGroupNumbers)
      .optionallyWith(
        phase1EncryptionAlgorithms.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.phase1EncryptionAlgorithms)
      .optionallyWith(
        phase1IntegrityAlgorithms.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.phase1IntegrityAlgorithms)
      .optionallyWith(
        phase1LifetimeSeconds.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.phase1LifetimeSeconds)
      .optionallyWith(
        phase2DhGroupNumbers.map(value =>
          value.map { item =>
            Integer.unwrap(item): java.lang.Integer
          }.asJavaCollection
        )
      )(_.phase2DhGroupNumbers)
      .optionallyWith(
        phase2EncryptionAlgorithms.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.phase2EncryptionAlgorithms)
      .optionallyWith(
        phase2IntegrityAlgorithms.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.phase2IntegrityAlgorithms)
      .optionallyWith(
        phase2LifetimeSeconds.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.phase2LifetimeSeconds)
      .optionallyWith(
        preSharedKey.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.preSharedKey)
      .optionallyWith(
        rekeyFuzzPercentage.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.rekeyFuzzPercentage)
      .optionallyWith(
        rekeyMarginTimeSeconds.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.rekeyMarginTimeSeconds)
      .optionallyWith(
        replayWindowSize.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.replayWindowSize)
      .optionallyWith(
        tunnelInsideCidr.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.tunnelInsideCidr)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails
      .wrap(buildAwsValue())
}
object AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails =
      zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails(
        dpdTimeoutSeconds.map(value => value),
        ikeVersions.map(value => value),
        outsideIpAddress.map(value => value),
        phase1DhGroupNumbers.map(value => value),
        phase1EncryptionAlgorithms.map(value => value),
        phase1IntegrityAlgorithms.map(value => value),
        phase1LifetimeSeconds.map(value => value),
        phase2DhGroupNumbers.map(value => value),
        phase2EncryptionAlgorithms.map(value => value),
        phase2IntegrityAlgorithms.map(value => value),
        phase2LifetimeSeconds.map(value => value),
        preSharedKey.map(value => value),
        rekeyFuzzPercentage.map(value => value),
        rekeyMarginTimeSeconds.map(value => value),
        replayWindowSize.map(value => value),
        tunnelInsideCidr.map(value => value)
      )
    def dpdTimeoutSeconds: Option[Integer]
    def ikeVersions: Option[List[NonEmptyString]]
    def outsideIpAddress: Option[NonEmptyString]
    def phase1DhGroupNumbers: Option[List[Integer]]
    def phase1EncryptionAlgorithms: Option[List[NonEmptyString]]
    def phase1IntegrityAlgorithms: Option[List[NonEmptyString]]
    def phase1LifetimeSeconds: Option[Integer]
    def phase2DhGroupNumbers: Option[List[Integer]]
    def phase2EncryptionAlgorithms: Option[List[NonEmptyString]]
    def phase2IntegrityAlgorithms: Option[List[NonEmptyString]]
    def phase2LifetimeSeconds: Option[Integer]
    def preSharedKey: Option[NonEmptyString]
    def rekeyFuzzPercentage: Option[Integer]
    def rekeyMarginTimeSeconds: Option[Integer]
    def replayWindowSize: Option[Integer]
    def tunnelInsideCidr: Option[NonEmptyString]
    def getDpdTimeoutSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("dpdTimeoutSeconds", dpdTimeoutSeconds)
    def getIkeVersions: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("ikeVersions", ikeVersions)
    def getOutsideIpAddress: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("outsideIpAddress", outsideIpAddress)
    def getPhase1DhGroupNumbers: ZIO[Any, AwsError, List[Integer]] =
      AwsError.unwrapOptionField("phase1DhGroupNumbers", phase1DhGroupNumbers)
    def getPhase1EncryptionAlgorithms
        : ZIO[Any, AwsError, List[NonEmptyString]] = AwsError.unwrapOptionField(
      "phase1EncryptionAlgorithms",
      phase1EncryptionAlgorithms
    )
    def getPhase1IntegrityAlgorithms: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "phase1IntegrityAlgorithms",
        phase1IntegrityAlgorithms
      )
    def getPhase1LifetimeSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("phase1LifetimeSeconds", phase1LifetimeSeconds)
    def getPhase2DhGroupNumbers: ZIO[Any, AwsError, List[Integer]] =
      AwsError.unwrapOptionField("phase2DhGroupNumbers", phase2DhGroupNumbers)
    def getPhase2EncryptionAlgorithms
        : ZIO[Any, AwsError, List[NonEmptyString]] = AwsError.unwrapOptionField(
      "phase2EncryptionAlgorithms",
      phase2EncryptionAlgorithms
    )
    def getPhase2IntegrityAlgorithms: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "phase2IntegrityAlgorithms",
        phase2IntegrityAlgorithms
      )
    def getPhase2LifetimeSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("phase2LifetimeSeconds", phase2LifetimeSeconds)
    def getPreSharedKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("preSharedKey", preSharedKey)
    def getRekeyFuzzPercentage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("rekeyFuzzPercentage", rekeyFuzzPercentage)
    def getRekeyMarginTimeSeconds: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("rekeyMarginTimeSeconds", rekeyMarginTimeSeconds)
    def getReplayWindowSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("replayWindowSize", replayWindowSize)
    def getTunnelInsideCidr: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("tunnelInsideCidr", tunnelInsideCidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails
  ) extends zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails.ReadOnly {
    override val dpdTimeoutSeconds: Option[Integer] = scala
      .Option(impl.dpdTimeoutSeconds())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val ikeVersions: Option[List[NonEmptyString]] = scala
      .Option(impl.ikeVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val outsideIpAddress: Option[NonEmptyString] = scala
      .Option(impl.outsideIpAddress())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val phase1DhGroupNumbers: Option[List[Integer]] = scala
      .Option(impl.phase1DhGroupNumbers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.Integer(item)
        }.toList
      )
    override val phase1EncryptionAlgorithms: Option[List[NonEmptyString]] =
      scala
        .Option(impl.phase1EncryptionAlgorithms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val phase1IntegrityAlgorithms: Option[List[NonEmptyString]] = scala
      .Option(impl.phase1IntegrityAlgorithms())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val phase1LifetimeSeconds: Option[Integer] = scala
      .Option(impl.phase1LifetimeSeconds())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val phase2DhGroupNumbers: Option[List[Integer]] = scala
      .Option(impl.phase2DhGroupNumbers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.Integer(item)
        }.toList
      )
    override val phase2EncryptionAlgorithms: Option[List[NonEmptyString]] =
      scala
        .Option(impl.phase2EncryptionAlgorithms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val phase2IntegrityAlgorithms: Option[List[NonEmptyString]] = scala
      .Option(impl.phase2IntegrityAlgorithms())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val phase2LifetimeSeconds: Option[Integer] = scala
      .Option(impl.phase2LifetimeSeconds())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val preSharedKey: Option[NonEmptyString] = scala
      .Option(impl.preSharedKey())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val rekeyFuzzPercentage: Option[Integer] = scala
      .Option(impl.rekeyFuzzPercentage())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val rekeyMarginTimeSeconds: Option[Integer] = scala
      .Option(impl.rekeyMarginTimeSeconds())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val replayWindowSize: Option[Integer] = scala
      .Option(impl.replayWindowSize())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val tunnelInsideCidr: Option[NonEmptyString] = scala
      .Option(impl.tunnelInsideCidr())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails
  ): zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
