package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEc2SecurityGroupIpRange(
    cidrIp: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpRange = {
    import AwsEc2SecurityGroupIpRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpRange
      .builder()
      .optionallyWith(
        cidrIp.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.cidrIp)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2SecurityGroupIpRange.ReadOnly =
    zio.aws.securityhub.model.AwsEc2SecurityGroupIpRange.wrap(buildAwsValue())
}
object AwsEc2SecurityGroupIpRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2SecurityGroupIpRange =
      zio.aws.securityhub.model
        .AwsEc2SecurityGroupIpRange(cidrIp.map(value => value))
    def cidrIp: Option[NonEmptyString]
    def getCidrIp: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cidrIp", cidrIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpRange
  ) extends zio.aws.securityhub.model.AwsEc2SecurityGroupIpRange.ReadOnly {
    override val cidrIp: Option[NonEmptyString] = scala
      .Option(impl.cidrIp())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpRange
  ): zio.aws.securityhub.model.AwsEc2SecurityGroupIpRange.ReadOnly =
    new Wrapper(impl)
}
