package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsDynamoDbTableRestoreSummary(
    sourceBackupArn: Option[NonEmptyString] = None,
    sourceTableArn: Option[NonEmptyString] = None,
    restoreDateTime: Option[NonEmptyString] = None,
    restoreInProgress: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableRestoreSummary = {
    import AwsDynamoDbTableRestoreSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableRestoreSummary
      .builder()
      .optionallyWith(
        sourceBackupArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sourceBackupArn)
      .optionallyWith(
        sourceTableArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sourceTableArn)
      .optionallyWith(
        restoreDateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.restoreDateTime)
      .optionallyWith(restoreInProgress.map(value => value: java.lang.Boolean))(
        _.restoreInProgress
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsDynamoDbTableRestoreSummary.ReadOnly =
    zio.aws.securityhub.model.AwsDynamoDbTableRestoreSummary
      .wrap(buildAwsValue())
}
object AwsDynamoDbTableRestoreSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableRestoreSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsDynamoDbTableRestoreSummary =
      zio.aws.securityhub.model.AwsDynamoDbTableRestoreSummary(
        sourceBackupArn.map(value => value),
        sourceTableArn.map(value => value),
        restoreDateTime.map(value => value),
        restoreInProgress.map(value => value)
      )
    def sourceBackupArn: Option[NonEmptyString]
    def sourceTableArn: Option[NonEmptyString]
    def restoreDateTime: Option[NonEmptyString]
    def restoreInProgress: Option[Boolean]
    def getSourceBackupArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceBackupArn", sourceBackupArn)
    def getSourceTableArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceTableArn", sourceTableArn)
    def getRestoreDateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("restoreDateTime", restoreDateTime)
    def getRestoreInProgress: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("restoreInProgress", restoreInProgress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableRestoreSummary
  ) extends zio.aws.securityhub.model.AwsDynamoDbTableRestoreSummary.ReadOnly {
    override val sourceBackupArn: Option[NonEmptyString] = scala
      .Option(impl.sourceBackupArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sourceTableArn: Option[NonEmptyString] = scala
      .Option(impl.sourceTableArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val restoreDateTime: Option[NonEmptyString] = scala
      .Option(impl.restoreDateTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val restoreInProgress: Option[Boolean] =
      scala.Option(impl.restoreInProgress()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableRestoreSummary
  ): zio.aws.securityhub.model.AwsDynamoDbTableRestoreSummary.ReadOnly =
    new Wrapper(impl)
}
