package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsDynamoDbTableProvisionedThroughput(
    lastDecreaseDateTime: Option[NonEmptyString] = None,
    lastIncreaseDateTime: Option[NonEmptyString] = None,
    numberOfDecreasesToday: Option[Integer] = None,
    readCapacityUnits: Option[Integer] = None,
    writeCapacityUnits: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProvisionedThroughput = {
    import AwsDynamoDbTableProvisionedThroughput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProvisionedThroughput
      .builder()
      .optionallyWith(
        lastDecreaseDateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastDecreaseDateTime)
      .optionallyWith(
        lastIncreaseDateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastIncreaseDateTime)
      .optionallyWith(
        numberOfDecreasesToday.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.numberOfDecreasesToday)
      .optionallyWith(
        readCapacityUnits.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.readCapacityUnits)
      .optionallyWith(
        writeCapacityUnits.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.writeCapacityUnits)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput.ReadOnly =
    zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput
      .wrap(buildAwsValue())
}
object AwsDynamoDbTableProvisionedThroughput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProvisionedThroughput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput =
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput(
        lastDecreaseDateTime.map(value => value),
        lastIncreaseDateTime.map(value => value),
        numberOfDecreasesToday.map(value => value),
        readCapacityUnits.map(value => value),
        writeCapacityUnits.map(value => value)
      )
    def lastDecreaseDateTime: Option[NonEmptyString]
    def lastIncreaseDateTime: Option[NonEmptyString]
    def numberOfDecreasesToday: Option[Integer]
    def readCapacityUnits: Option[Integer]
    def writeCapacityUnits: Option[Integer]
    def getLastDecreaseDateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastDecreaseDateTime", lastDecreaseDateTime)
    def getLastIncreaseDateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastIncreaseDateTime", lastIncreaseDateTime)
    def getNumberOfDecreasesToday: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("numberOfDecreasesToday", numberOfDecreasesToday)
    def getReadCapacityUnits: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("readCapacityUnits", readCapacityUnits)
    def getWriteCapacityUnits: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("writeCapacityUnits", writeCapacityUnits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProvisionedThroughput
  ) extends zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput.ReadOnly {
    override val lastDecreaseDateTime: Option[NonEmptyString] = scala
      .Option(impl.lastDecreaseDateTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val lastIncreaseDateTime: Option[NonEmptyString] = scala
      .Option(impl.lastIncreaseDateTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val numberOfDecreasesToday: Option[Integer] = scala
      .Option(impl.numberOfDecreasesToday())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val readCapacityUnits: Option[Integer] = scala
      .Option(impl.readCapacityUnits())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val writeCapacityUnits: Option[Integer] = scala
      .Option(impl.writeCapacityUnits())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProvisionedThroughput
  ): zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput.ReadOnly =
    new Wrapper(impl)
}
