package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Action(
    actionType: Option[NonEmptyString] = None,
    networkConnectionAction: Option[
      zio.aws.securityhub.model.NetworkConnectionAction
    ] = None,
    awsApiCallAction: Option[zio.aws.securityhub.model.AwsApiCallAction] = None,
    dnsRequestAction: Option[zio.aws.securityhub.model.DnsRequestAction] = None,
    portProbeAction: Option[zio.aws.securityhub.model.PortProbeAction] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Action = {
    import Action.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Action
      .builder()
      .optionallyWith(
        actionType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.actionType)
      .optionallyWith(
        networkConnectionAction.map(value => value.buildAwsValue())
      )(_.networkConnectionAction)
      .optionallyWith(awsApiCallAction.map(value => value.buildAwsValue()))(
        _.awsApiCallAction
      )
      .optionallyWith(dnsRequestAction.map(value => value.buildAwsValue()))(
        _.dnsRequestAction
      )
      .optionallyWith(portProbeAction.map(value => value.buildAwsValue()))(
        _.portProbeAction
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Action.ReadOnly =
    zio.aws.securityhub.model.Action.wrap(buildAwsValue())
}
object Action {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Action
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Action =
      zio.aws.securityhub.model.Action(
        actionType.map(value => value),
        networkConnectionAction.map(value => value.asEditable),
        awsApiCallAction.map(value => value.asEditable),
        dnsRequestAction.map(value => value.asEditable),
        portProbeAction.map(value => value.asEditable)
      )
    def actionType: Option[NonEmptyString]
    def networkConnectionAction
        : Option[zio.aws.securityhub.model.NetworkConnectionAction.ReadOnly]
    def awsApiCallAction
        : Option[zio.aws.securityhub.model.AwsApiCallAction.ReadOnly]
    def dnsRequestAction
        : Option[zio.aws.securityhub.model.DnsRequestAction.ReadOnly]
    def portProbeAction
        : Option[zio.aws.securityhub.model.PortProbeAction.ReadOnly]
    def getActionType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("actionType", actionType)
    def getNetworkConnectionAction: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.NetworkConnectionAction.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkConnectionAction",
      networkConnectionAction
    )
    def getAwsApiCallAction: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsApiCallAction.ReadOnly
    ] = AwsError.unwrapOptionField("awsApiCallAction", awsApiCallAction)
    def getDnsRequestAction: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.DnsRequestAction.ReadOnly
    ] = AwsError.unwrapOptionField("dnsRequestAction", dnsRequestAction)
    def getPortProbeAction: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.PortProbeAction.ReadOnly
    ] = AwsError.unwrapOptionField("portProbeAction", portProbeAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Action
  ) extends zio.aws.securityhub.model.Action.ReadOnly {
    override val actionType: Option[NonEmptyString] = scala
      .Option(impl.actionType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val networkConnectionAction
        : Option[zio.aws.securityhub.model.NetworkConnectionAction.ReadOnly] =
      scala
        .Option(impl.networkConnectionAction())
        .map(value =>
          zio.aws.securityhub.model.NetworkConnectionAction.wrap(value)
        )
    override val awsApiCallAction
        : Option[zio.aws.securityhub.model.AwsApiCallAction.ReadOnly] = scala
      .Option(impl.awsApiCallAction())
      .map(value => zio.aws.securityhub.model.AwsApiCallAction.wrap(value))
    override val dnsRequestAction
        : Option[zio.aws.securityhub.model.DnsRequestAction.ReadOnly] = scala
      .Option(impl.dnsRequestAction())
      .map(value => zio.aws.securityhub.model.DnsRequestAction.wrap(value))
    override val portProbeAction
        : Option[zio.aws.securityhub.model.PortProbeAction.ReadOnly] = scala
      .Option(impl.portProbeAction())
      .map(value => zio.aws.securityhub.model.PortProbeAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Action
  ): zio.aws.securityhub.model.Action.ReadOnly = new Wrapper(impl)
}
