package zio.aws.secretsmanager.model
import scala.jdk.CollectionConverters._
sealed trait StatusType {
  def unwrap: software.amazon.awssdk.services.secretsmanager.model.StatusType
}
object StatusType {
  def wrap(
      value: software.amazon.awssdk.services.secretsmanager.model.StatusType
  ): zio.aws.secretsmanager.model.StatusType = value match {
    case software.amazon.awssdk.services.secretsmanager.model.StatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.secretsmanager.model.StatusType.IN_SYNC =>
      val r = InSync
      r
    case software.amazon.awssdk.services.secretsmanager.model.StatusType.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.secretsmanager.model.StatusType.IN_PROGRESS =>
      val r = InProgress
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.secretsmanager.model.StatusType {
    override def unwrap
        : software.amazon.awssdk.services.secretsmanager.model.StatusType =
      software.amazon.awssdk.services.secretsmanager.model.StatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object InSync extends zio.aws.secretsmanager.model.StatusType {
    override def unwrap
        : software.amazon.awssdk.services.secretsmanager.model.StatusType =
      software.amazon.awssdk.services.secretsmanager.model.StatusType.IN_SYNC
  }
  case object Failed extends zio.aws.secretsmanager.model.StatusType {
    override def unwrap
        : software.amazon.awssdk.services.secretsmanager.model.StatusType =
      software.amazon.awssdk.services.secretsmanager.model.StatusType.FAILED
  }
  case object InProgress extends zio.aws.secretsmanager.model.StatusType {
    override def unwrap
        : software.amazon.awssdk.services.secretsmanager.model.StatusType =
      software.amazon.awssdk.services.secretsmanager.model.StatusType.IN_PROGRESS
  }
}
