package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.SecretARNType
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopReplicationToReplicaResponse(
    arn: Optional[SecretARNType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.StopReplicationToReplicaResponse = {
    import StopReplicationToReplicaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.StopReplicationToReplicaResponse
      .builder()
      .optionallyWith(
        arn.map(value => SecretARNType.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.StopReplicationToReplicaResponse.ReadOnly =
    zio.aws.secretsmanager.model.StopReplicationToReplicaResponse
      .wrap(buildAwsValue())
}
object StopReplicationToReplicaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.StopReplicationToReplicaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.secretsmanager.model.StopReplicationToReplicaResponse =
      zio.aws.secretsmanager.model
        .StopReplicationToReplicaResponse(arn.map(value => value))
    def arn: Optional[SecretARNType]
    def getArn: ZIO[Any, AwsError, SecretARNType] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.StopReplicationToReplicaResponse
  ) extends zio.aws.secretsmanager.model.StopReplicationToReplicaResponse.ReadOnly {
    override val arn: Optional[SecretARNType] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretARNType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.StopReplicationToReplicaResponse
  ): zio.aws.secretsmanager.model.StopReplicationToReplicaResponse.ReadOnly =
    new Wrapper(impl)
}
