package zio.aws.secretsmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.secretsmanager.model.primitives.{
  LastAccessedDateType,
  StatusMessageType,
  KmsKeyIdType,
  RegionType
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ReplicationStatusType(
    region: Optional[RegionType] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyIdType] = Optional.Absent,
    status: Optional[zio.aws.secretsmanager.model.StatusType] = Optional.Absent,
    statusMessage: Optional[StatusMessageType] = Optional.Absent,
    lastAccessedDate: Optional[LastAccessedDateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.ReplicationStatusType = {
    import ReplicationStatusType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.ReplicationStatusType
      .builder()
      .optionallyWith(
        region.map(value => RegionType.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyIdType.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessageType.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        lastAccessedDate.map(value =>
          LastAccessedDateType.unwrap(value): Instant
        )
      )(_.lastAccessedDate)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.ReplicationStatusType.ReadOnly =
    zio.aws.secretsmanager.model.ReplicationStatusType.wrap(buildAwsValue())
}
object ReplicationStatusType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.ReplicationStatusType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.ReplicationStatusType =
      zio.aws.secretsmanager.model.ReplicationStatusType(
        region.map(value => value),
        kmsKeyId.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        lastAccessedDate.map(value => value)
      )
    def region: Optional[RegionType]
    def kmsKeyId: Optional[KmsKeyIdType]
    def status: Optional[zio.aws.secretsmanager.model.StatusType]
    def statusMessage: Optional[StatusMessageType]
    def lastAccessedDate: Optional[LastAccessedDateType]
    def getRegion: ZIO[Any, AwsError, RegionType] =
      AwsError.unwrapOptionField("region", region)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyIdType] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getStatus: ZIO[Any, AwsError, zio.aws.secretsmanager.model.StatusType] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessageType] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getLastAccessedDate: ZIO[Any, AwsError, LastAccessedDateType] =
      AwsError.unwrapOptionField("lastAccessedDate", lastAccessedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.ReplicationStatusType
  ) extends zio.aws.secretsmanager.model.ReplicationStatusType.ReadOnly {
    override val region: Optional[RegionType] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.secretsmanager.model.primitives.RegionType(value))
    override val kmsKeyId: Optional[KmsKeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.secretsmanager.model.primitives.KmsKeyIdType(value))
    override val status: Optional[zio.aws.secretsmanager.model.StatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.secretsmanager.model.StatusType.wrap(value))
    override val statusMessage: Optional[StatusMessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.StatusMessageType(value)
        )
    override val lastAccessedDate: Optional[LastAccessedDateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastAccessedDate())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.LastAccessedDateType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.ReplicationStatusType
  ): zio.aws.secretsmanager.model.ReplicationStatusType.ReadOnly = new Wrapper(
    impl
  )
}
