package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  NonEmptyResourcePolicyType,
  SecretIdType
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ValidateResourcePolicyRequest(
    secretId: Optional[SecretIdType] = Optional.Absent,
    resourcePolicy: NonEmptyResourcePolicyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.ValidateResourcePolicyRequest = {
    import ValidateResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.ValidateResourcePolicyRequest
      .builder()
      .optionallyWith(
        secretId.map(value => SecretIdType.unwrap(value): java.lang.String)
      )(_.secretId)
      .resourcePolicy(
        NonEmptyResourcePolicyType.unwrap(resourcePolicy): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.ValidateResourcePolicyRequest.ReadOnly =
    zio.aws.secretsmanager.model.ValidateResourcePolicyRequest
      .wrap(buildAwsValue())
}
object ValidateResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.ValidateResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.ValidateResourcePolicyRequest =
      zio.aws.secretsmanager.model.ValidateResourcePolicyRequest(
        secretId.map(value => value),
        resourcePolicy
      )
    def secretId: Optional[SecretIdType]
    def resourcePolicy: NonEmptyResourcePolicyType
    def getSecretId: ZIO[Any, AwsError, SecretIdType] =
      AwsError.unwrapOptionField("secretId", secretId)
    def getResourcePolicy: ZIO[Any, Nothing, NonEmptyResourcePolicyType] =
      ZIO.succeed(resourcePolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.ValidateResourcePolicyRequest
  ) extends zio.aws.secretsmanager.model.ValidateResourcePolicyRequest.ReadOnly {
    override val secretId: Optional[SecretIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.secretId())
      .map(value => zio.aws.secretsmanager.model.primitives.SecretIdType(value))
    override val resourcePolicy: NonEmptyResourcePolicyType =
      zio.aws.secretsmanager.model.primitives
        .NonEmptyResourcePolicyType(impl.resourcePolicy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.ValidateResourcePolicyRequest
  ): zio.aws.secretsmanager.model.ValidateResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
