package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  BooleanType,
  RotationLambdaARNType,
  ClientRequestTokenType,
  SecretIdType
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RotateSecretRequest(
    secretId: SecretIdType,
    clientRequestToken: Optional[ClientRequestTokenType] = Optional.Absent,
    rotationLambdaARN: Optional[RotationLambdaARNType] = Optional.Absent,
    rotationRules: Optional[zio.aws.secretsmanager.model.RotationRulesType] =
      Optional.Absent,
    rotateImmediately: Optional[BooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.RotateSecretRequest = {
    import RotateSecretRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.RotateSecretRequest
      .builder()
      .secretId(SecretIdType.unwrap(secretId): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestTokenType.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        rotationLambdaARN.map(value =>
          RotationLambdaARNType.unwrap(value): java.lang.String
        )
      )(_.rotationLambdaARN)
      .optionallyWith(rotationRules.map(value => value.buildAwsValue()))(
        _.rotationRules
      )
      .optionallyWith(
        rotateImmediately.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.rotateImmediately)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.RotateSecretRequest.ReadOnly =
    zio.aws.secretsmanager.model.RotateSecretRequest.wrap(buildAwsValue())
}
object RotateSecretRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.RotateSecretRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.RotateSecretRequest =
      zio.aws.secretsmanager.model.RotateSecretRequest(
        secretId,
        clientRequestToken.map(value => value),
        rotationLambdaARN.map(value => value),
        rotationRules.map(value => value.asEditable),
        rotateImmediately.map(value => value)
      )
    def secretId: SecretIdType
    def clientRequestToken: Optional[ClientRequestTokenType]
    def rotationLambdaARN: Optional[RotationLambdaARNType]
    def rotationRules
        : Optional[zio.aws.secretsmanager.model.RotationRulesType.ReadOnly]
    def rotateImmediately: Optional[BooleanType]
    def getSecretId: ZIO[Any, Nothing, SecretIdType] = ZIO.succeed(secretId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestTokenType] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getRotationLambdaARN: ZIO[Any, AwsError, RotationLambdaARNType] =
      AwsError.unwrapOptionField("rotationLambdaARN", rotationLambdaARN)
    def getRotationRules: ZIO[
      Any,
      AwsError,
      zio.aws.secretsmanager.model.RotationRulesType.ReadOnly
    ] = AwsError.unwrapOptionField("rotationRules", rotationRules)
    def getRotateImmediately: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("rotateImmediately", rotateImmediately)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.RotateSecretRequest
  ) extends zio.aws.secretsmanager.model.RotateSecretRequest.ReadOnly {
    override val secretId: SecretIdType =
      zio.aws.secretsmanager.model.primitives.SecretIdType(impl.secretId())
    override val clientRequestToken: Optional[ClientRequestTokenType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.ClientRequestTokenType(value)
        )
    override val rotationLambdaARN: Optional[RotationLambdaARNType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rotationLambdaARN())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.RotationLambdaARNType(value)
        )
    override val rotationRules
        : Optional[zio.aws.secretsmanager.model.RotationRulesType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rotationRules())
        .map(value =>
          zio.aws.secretsmanager.model.RotationRulesType.wrap(value)
        )
    override val rotateImmediately: Optional[BooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rotateImmediately())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.BooleanType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.RotateSecretRequest
  ): zio.aws.secretsmanager.model.RotateSecretRequest.ReadOnly = new Wrapper(
    impl
  )
}
