package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.SecretIdType
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopReplicationToReplicaRequest(secretId: SecretIdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.StopReplicationToReplicaRequest = {
    import StopReplicationToReplicaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.StopReplicationToReplicaRequest
      .builder()
      .secretId(SecretIdType.unwrap(secretId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.StopReplicationToReplicaRequest.ReadOnly =
    zio.aws.secretsmanager.model.StopReplicationToReplicaRequest
      .wrap(buildAwsValue())
}
object StopReplicationToReplicaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.StopReplicationToReplicaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.secretsmanager.model.StopReplicationToReplicaRequest =
      zio.aws.secretsmanager.model.StopReplicationToReplicaRequest(secretId)
    def secretId: SecretIdType
    def getSecretId: ZIO[Any, Nothing, SecretIdType] = ZIO.succeed(secretId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.StopReplicationToReplicaRequest
  ) extends zio.aws.secretsmanager.model.StopReplicationToReplicaRequest.ReadOnly {
    override val secretId: SecretIdType =
      zio.aws.secretsmanager.model.primitives.SecretIdType(impl.secretId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.StopReplicationToReplicaRequest
  ): zio.aws.secretsmanager.model.StopReplicationToReplicaRequest.ReadOnly =
    new Wrapper(impl)
}
