package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.RandomPasswordType
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRandomPasswordResponse(
    randomPassword: Optional[RandomPasswordType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.GetRandomPasswordResponse = {
    import GetRandomPasswordResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.GetRandomPasswordResponse
      .builder()
      .optionallyWith(
        randomPassword.map(value =>
          RandomPasswordType.unwrap(value): java.lang.String
        )
      )(_.randomPassword)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.GetRandomPasswordResponse.ReadOnly =
    zio.aws.secretsmanager.model.GetRandomPasswordResponse.wrap(buildAwsValue())
}
object GetRandomPasswordResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.GetRandomPasswordResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.GetRandomPasswordResponse =
      zio.aws.secretsmanager.model
        .GetRandomPasswordResponse(randomPassword.map(value => value))
    def randomPassword: Optional[RandomPasswordType]
    def getRandomPassword: ZIO[Any, AwsError, RandomPasswordType] =
      AwsError.unwrapOptionField("randomPassword", randomPassword)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.GetRandomPasswordResponse
  ) extends zio.aws.secretsmanager.model.GetRandomPasswordResponse.ReadOnly {
    override val randomPassword: Optional[RandomPasswordType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.randomPassword())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.RandomPasswordType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.GetRandomPasswordResponse
  ): zio.aws.secretsmanager.model.GetRandomPasswordResponse.ReadOnly =
    new Wrapper(impl)
}
